package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.os.Build;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.view.MyProgressBar;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/2/24.
 */
public class PaymentMethodAdapter extends BaseQuickAdapter<PaymentMethodBean.DataBean, BaseViewHolder> {

    public static int[] colors = new int[]{R.color.payment_method_color1,
            R.color.payment_method_color2, R.color.payment_method_color3,
            R.color.payment_method_color4, R.color.payment_method_color5,
            R.color.payment_method_color6, R.color.payment_method_color7,
            R.color.payment_method_color8};
    private Context context;

    public PaymentMethodAdapter(Context context, @Nullable List<PaymentMethodBean.DataBean> data) {
        super(R.layout.item_payment_method, data);
        this.context = context;
    }

    @Override
    protected void convert(BaseViewHolder helper, PaymentMethodBean.DataBean item) {
        helper.setText(R.id.tv_payment_method_name, item.getPayName());
        MyProgressBar progressBar = helper.getView(R.id.pb_payment_percentage);
        float progress = Float.parseFloat(item.getPercentage().replace("%", ""));
        progressBar.setMax(100);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            progressBar.setProgress((int) progress, true);
        } else {
            progressBar.setProgress((int) progress);
        }
        progressBar.setmReachedColor(context.getResources().getColor(colors[helper.getAdapterPosition() % colors.length]));
        helper.setText(R.id.tv_payment_num, "數量：" + item.getNum());
        helper.setText(R.id.tv_payment_amount, "$" + item.getAmount());
    }
}
