package com.joe.print.mvp.ui.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.WindowManager;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.joe.print.mvp.print.SendPrint;

import am.util.printer.PrintExecutor;
import am.util.printer.PrintSocketHolder;
import am.util.printer.PrinterWriter58mm;
import am.util.printer.PrinterWriter80mm;
import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/7.
 */
public class OldPrintActivity extends Activity implements PrintSocketHolder.OnStateChangedListener, PrintExecutor.OnPrintResultListener, DialogInterface.OnDismissListener {

    private PrintExecutor executor;
    private SendPrint maker;
    private Dialog dialog;

    private String callId;
    /**-
     * 是否打印成功 true：成功
     */
    private boolean printStatus = false;

    private String ip;
    private Integer port;
    private int paperType = 1;//打印紙類型 1：58mm，2：:80mm
    private int printWidth = 560;//打印出來的內容寬度
    /**
     * -1：打印測試
     * 0：上菜紙
     * 1：印單
     * 2：結賬單
     * 3：廚房單
     */
    private int type = -1;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
                | WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH);
        super.onCreate(savedInstanceState);
        getWindow().setBackgroundDrawable(null);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        initIntent();
        callId = getIntent().getStringExtra("callId");
        printOrder(this);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        //點擊當前頁面任意地方自動關閉
        finish();
        return true;
    }
    private void initIntent() {
        Intent intent = getIntent();
        ip = intent.getStringExtra("ip");
        port = intent.getIntExtra("port", 0);
        paperType = intent.getIntExtra("paperType", 1);
        type = intent.getIntExtra("type", -1);
        if (ip == null || ip.equals("")) {
            ip = "192.168.1.217";
        }
        if (paperType == 1) {
            paperType = PrinterWriter58mm.TYPE_58;
            printWidth = 580 - 20;//兩邊留20的空隙
        } else {
            paperType = PrinterWriter80mm.TYPE_80;
            printWidth = 800 - 20;//兩邊留20的空隙
        }
    }

    public void printOrder(Context context) {
        if (dialog != null) {
            dialog.dismiss();
        }
        dialog = LoadingDialog.showNewDialogForLoading(this, "初始化...", true);
        dialog.setOnDismissListener(dialog -> dismiss(""));
        dialog.setOnCancelListener(dialog -> dismiss(""));
        if (executor == null) {
            executor = new PrintExecutor(ip, port, paperType);
            executor.setOnStateChangedListener(this);
            executor.setOnPrintResultListener(this);
        }
        if (maker == null) {
            maker = new SendPrint(context, 255, printWidth, type);
        }
        executor.setIp(ip, port);
        executor.doPrinterRequestAsync(maker);
        executor.setReconnectTimes(3);
    }

    @Override
    public void onResult(int errorCode) {
        String msg = "";
        switch (errorCode) {
            case PrintSocketHolder.ERROR_0:
                //打印成功
                msg = "打印成功";
                printStatus = true;
                dismiss(msg);
                break;
            case PrintSocketHolder.ERROR_2:
            case PrintSocketHolder.ERROR_100:
                //创建Socket失败
                msg = "連接打印機失敗";
                printStatus = false;
                dismiss(msg);
                break;
            case PrintSocketHolder.ERROR_1:
            case PrintSocketHolder.ERROR_3:
            case PrintSocketHolder.ERROR_4:
            case PrintSocketHolder.ERROR_5:
                //打印失敗
                msg = "打印失敗";
                dismiss(msg);
                printStatus = false;
                break;
            default:

                break;
        }
        LoadingDialog.setText(msg);
    }

    @Override
    public void onStateChanged(int state) {
        String msg = "";
        switch (state) {
            case PrintSocketHolder.STATE_0:
            case PrintSocketHolder.STATE_1:
                //创建Socket连接
                msg = "連接打印機...";
                break;
            case PrintSocketHolder.STATE_2:
            case PrintSocketHolder.STATE_3:
                //写入测试页面数据
                msg = "正在打印...";
                break;
            case PrintSocketHolder.STATE_4:
                msg = "正在關閉...";
                dismiss(msg);
                break;
        }
        LoadingDialog.setText(msg);
    }


    private void dismiss(String msg) {
        if (msg != null && !msg.equals("")) {
            ToastUtils.show(this, msg);
        }
        //延遲一秒
        dialog.dismiss();
        dialog.setOnCancelListener(dialog -> finish());
        LoadingDialog.cancelDialogForLoading();
        //判断是否为CC调用打开本页面
        if (callId != null) {
            CCResult result;
            if (printStatus) {
                result = CCResult.success();
            } else {
                result = CCResult.error("print error");
            }
            //为确保不管登录成功与否都会调用CC.sendCCResult，在onDestroy方法中调用
            CC.sendCCResult(callId, result);
        }
        finish();
    }
    @Override
    public void onDismiss(DialogInterface dialog) {
        finish();
    }
}
