package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerFineItemKindComponent;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemKindContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.FineItemKindPresenter;

import org.simple.eventbus.Subscriber;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FineItemKindFragment extends BaseFragment<FineItemKindPresenter> implements FineItemKindContract.View {

    @BindView(R2.id.recycle_fine_item_kind)
    RecyclerView recycle_fine_item_kind; //细项分类

    @BindView(R2.id.recycle_fine_item_kind_item)
    RecyclerView recycle_fine_item_kind_item;//细项分类详细数据

    private int modCol;

    public static FineItemKindFragment newInstance() {
        FineItemKindFragment fragment = new FineItemKindFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFineItemKindComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_fine_item_kind, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        modCol = GsaCloudApplication.androidSetting.getModCol();

        mPresenter.initAdapter();
        mPresenter.initItemListener(getActivity());
    }

//    @Subscriber(tag = "FineItemKindFragment_onCurrentSlodoutFoodList_FullEvent")
//    public void onCurrentSlodoutFoodList_FullEvent(List<CurrentSoldoutFood.DatasBean> event) {
//        if (event == null) {
//            return;
//        }
//        mPresenter.updateCurrentSlodoutFoodList_Full1(event);
//        mPresenter.updateCurrentSlodoutFoodList_Full2(event);
//    }

    @Subscriber(tag = "FineItemKindFragment_onMidEvent")
    public void onMidEvent(long mid) {
        if (mid == 0) {
            return;
        }
        mPresenter.initFineItemKindData(mid);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(getCurrentActivity(),message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public void setFineItemKindAdapter(DefaultAdapter adapter) {
        recycle_fine_item_kind.setAdapter(adapter);
        initFineItemOneRecycleView();
    }

    @Override
    public void setFineItemKindItemAdapter(DefaultAdapter adapter) {
        recycle_fine_item_kind_item.setAdapter(adapter);
        initFineItemTwoRecycleView();
    }

    @Override
    public RecyclerView getRecycle_fine_item_kind() {
        return recycle_fine_item_kind;
    }

    @Override
    public RecyclerView getRecycle_fine_item_kind_item() {
        return recycle_fine_item_kind_item;
    }

    private GridLayoutManager mFineItemOneRecycleLayoutManager;
    private GridLayoutManager mFineItemTwoRecycleLayoutManager;

    public void initFineItemOneRecycleView() {
        mFineItemOneRecycleLayoutManager = new GridLayoutManager(getActivity(), 1, LinearLayoutManager.VERTICAL, false);
        recycle_fine_item_kind.setLayoutManager(mFineItemOneRecycleLayoutManager);
        recycle_fine_item_kind.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemOneRecycleView2() {
        mFineItemOneRecycleLayoutManager = new GridLayoutManager(getActivity(), 1, LinearLayoutManager.HORIZONTAL, false);
        recycle_fine_item_kind.setLayoutManager(mFineItemOneRecycleLayoutManager);
        recycle_fine_item_kind.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemTwoRecycleView() {
        mFineItemTwoRecycleLayoutManager = new GridLayoutManager(getActivity(), 1, LinearLayoutManager.VERTICAL, false);
        recycle_fine_item_kind_item.setLayoutManager(mFineItemTwoRecycleLayoutManager);
        recycle_fine_item_kind_item.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemTwoRecycleView2() {
        mFineItemTwoRecycleLayoutManager = new GridLayoutManager(getActivity(), 1, LinearLayoutManager.HORIZONTAL, false);
        recycle_fine_item_kind_item.setLayoutManager(mFineItemTwoRecycleLayoutManager);
        recycle_fine_item_kind_item.setItemAnimator(new DefaultItemAnimator());
    }

    @Override
    public void setFineItemKindRecycleSpanCount(int size) {
        if (size > 0) {
            if (size > modCol) {
                initFineItemOneRecycleView();
                mFineItemOneRecycleLayoutManager.setSpanCount(modCol);
            } else {
                initFineItemOneRecycleView2();
            }
        }
    }

    @Override
    public void setFineItemKindItemRecycleSpanCount(int size) {
        if (size > 0) {
            if (size > modCol) {
                initFineItemTwoRecycleView();
                mFineItemTwoRecycleLayoutManager.setSpanCount(modCol);
            } else {
                initFineItemTwoRecycleView2();
            }
        }
    }

    @Override
    public Activity getCurrentActivity() {
        return getActivity();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        //使dialog的生命周期与Fragment同步
        hideLoading();
    }
}
