package com.joe.print.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.PrinterAddContract;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/16/2020 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class PrinterAddPresenter extends BasePresenter<PrinterAddContract.Model, PrinterAddContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;


//    private List<PrintModelBean> printModelBeans;
//    private List<String> printModelLabels = new ArrayList<>();
//
//    private int modelPosition = -1;
//
//    public List<String> getPrintModelLabels() {
//        return printModelLabels;
//    }
//
//    public List<PrintModelBean> getPrintModelBeans() {
//        return printModelBeans;
//    }
//
//    public int getModelPosition() {
//        return modelPosition;
//    }
//
//    public void setModelPosition(int modelPosition) {
//        this.modelPosition = modelPosition;
//    }

    @Inject
    public PrinterAddPresenter(PrinterAddContract.Model model, PrinterAddContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    /**
     * 添加打印機
     */
    public void addPrinter(PrinterDeviceBean printerDeviceBean) {
        mModel.addPrinter(getRequestBody(printerDeviceBean))
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            mRootView.addPrinterSuccess(printerDeviceBean);
                        } else {
                            mRootView.showMessage("保存失敗");
                        }
                    }
                });
    }

    /**
     * 更新打印機信息
     */
    public void updatePrinterInfo(PrinterDeviceBean printerDeviceBean) {
        mModel.updatePrinter(getRequestBody(printerDeviceBean))
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            mRootView.showMessage("保存成功");
                            mRootView.killMyself();
                        }
                    }
                });
    }

    private RequestBody getRequestBody(PrinterDeviceBean printerDeviceBean) {
        FormBody.Builder builder = new FormBody.Builder()
                .add("restaurantId", printerDeviceBean.getRestaurantId() + "")
                .add("name", printerDeviceBean.getName())
                .add("ip", printerDeviceBean.getIp())
                .add("port", printerDeviceBean.getPort() + "")
                .add("printerModelId", printerDeviceBean.getPrinterModelId() + "")
                .add("type", printerDeviceBean.getType() + "")
                .add("id", printerDeviceBean.getId() + "")
                .add("foodIsBold", printerDeviceBean.getFoodIsBold() + "")
                .add("foodFont", printerDeviceBean.getFoodFont() + "")
                .add("foodIsItalic", printerDeviceBean.getFoodIsItalic() + "")
                .add("modifierIsBold", printerDeviceBean.getModifierIsBold() + "")
                .add("modifierFont", printerDeviceBean.getModifierFont() + "")
                .add("modifierIsItalic", printerDeviceBean.getModifierIsItalic() + "")
                .add("numberIsFlip", printerDeviceBean.getNumberIsFlip() + "")
                .add("printerDeviceType", printerDeviceBean.getPrinterDeviceType() + "")
                .add("languageType", printerDeviceBean.getLanguageType() + "");
        if (printerDeviceBean.getFlyPrinterDeviceId() != null) {
            builder.add("flyPrinterDeviceId", printerDeviceBean.getFlyPrinterDeviceId() + "");
        }
        if (printerDeviceBean.getFlyPrinterDeviceId2() != null) {
            builder.add("flyPrinterDeviceId2", printerDeviceBean.getFlyPrinterDeviceId2() + "");
        }
        return builder.build();
    }


    /**
     * 獲取打印機機型列表
     */
//    public void getModelList(int restaurantId) {
//        mModel.getPrintModel(restaurantId)
//                .subscribeOn(Schedulers.io())
//                .doOnSubscribe(disposable -> mRootView.showLoading(""))
//                .subscribeOn(AndroidSchedulers.mainThread())
//                .observeOn(AndroidSchedulers.mainThread())
//                .doAfterTerminate(() -> mRootView.hideLoading())
//                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
//                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
//                    @Override
//                    public void onNext(BaseResult baseResult) {
//                        if (baseResult.isSuccess()) {
//                            printModelBeans = JsonUtils.parseArray(baseResult.getData(), PrintModelBean.class);
//                            if (printModelBeans != null && printModelBeans.size() > 0) {
//                                for (int i = 0; i < printModelBeans.size(); i++) {
//                                    printModelLabels.add(printModelBeans.get(i).getPrinterName() + "\u3000" + printModelBeans.get(i).getModel());
//                                }
//                            }
//                        }
//                    }
//                });
//    }

}
