package com.gingersoft.supply_chain.mvp.ui.fragment.inventory;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.loadsir.ErrorCallback;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerStorageListComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderDetailsBean;
import com.gingersoft.supply_chain.mvp.bean.WareHousingOrderBean;
import com.gingersoft.supply_chain.mvp.contract.StorageListContract;
import com.gingersoft.supply_chain.mvp.presenter.StorageListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchasePageAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WareHousingAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.gingersoft.supply_chain.mvp.ui.widget.ScreenView;
import com.jess.arms.di.component.AppComponent;
import com.kingja.loadsir.callback.SuccessCallback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * Description: 入庫單列表
 */
public class StorageListFragment extends BaseSupplyChainFragment<StorageListPresenter> implements StorageListContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_purchase_list)
    QMUITopBar mTopBar;
    @BindView(R2.id.ed_food_ingredients_search)
    EditText edFoodIngredientsSearch;
    @BindView(R2.id.layout_purchase_list_screen)
    QMUILinearLayout layoutPurchaseListScreen;
    @BindView(R2.id.layout_food_ingredients_search)
    LinearLayout layoutFoodIngredientsSearch;
    @BindView(R2.id.screen_view)
    ScreenView screenView;
    @BindView(R2.id.purchase_list_tabSegment)
    QMUITabSegment2 mTabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager2 contentViewPager;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnSave;
    @BindView(R2.id.view_load_bg)
    View replaceView;
    String[] tabs = new String[]{"待收貨", "已完成"};
    private int pageIndex = 0;
    private int stateIndex = 0;
    private final int[] orderState = new int[]{PurchaseOrderDetailsBean.WAIT_RECEIVED, PurchaseOrderDetailsBean.COMPLETE_RECEIVED};

    private LoadService loadSir;

    public static StorageListFragment newInstance() {
        StorageListFragment fragment = new StorageListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerStorageListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_purchase_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        loadSir = LoadSir.getDefault().register(replaceView);
        initTopBar();
        initTabAndData();

    }

    private void getInfoList() {
        mPresenter.getStorageList(pageIndex, orderState[stateIndex], "");
    }

    private void initTopBar() {
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("入庫列表");
        btnSave.setVisibility(View.GONE);
    }

    private WareHousingAdapter wareHouseAdapter;

    private void initTabAndData() {
        QMUITabBuilder builder = mTabSegment.tabBuilder()
                .setNormalColor(ContextCompat.getColor(mContext, R.color.color_86))
                .setSelectColor(ContextCompat.getColor(mContext, R.color.theme_color));

//        List<OrderBean> orderBeans = new ArrayList<>();
//        StorageAdapter storageAdapter = new StorageAdapter(orderBeans);
        wareHouseAdapter = new WareHousingAdapter();
        PurchasePageAdapter adapter = new PurchasePageAdapter(wareHouseAdapter, tabs.length);
        contentViewPager.setAdapter(adapter);
        mTabSegment.setupWithViewPager(contentViewPager);
        mTabSegment.setIndicator(new QMUITabIndicator(
                QMUIDisplayHelper.dp2px(getContext(), 2), false, false));
        for (String tab : tabs) {
            mTabSegment.addTab(builder.setText(tab).build(getContext()));
        }
        mTabSegment.setMode(QMUITabSegment.MODE_FIXED);
        mTabSegment.addOnTabSelectedListener(new QMUIBasicTabSegment.OnTabSelectedListener() {
            @Override
            public void onTabSelected(int index) {
                stateIndex = index;
                getInfoList();
            }

            @Override
            public void onTabUnselected(int index) {

            }

            @Override
            public void onTabReselected(int index) {

            }

            @Override
            public void onDoubleTap(int index) {
                mTabSegment.clearSignCountView(index);
            }
        });
    }

    @OnClick({R2.id.layout_purchase_list_screen})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.layout_purchase_list_screen) {
            screenView.setVisibility(screenView.getVisibility() == View.VISIBLE ? View.GONE : View.VISIBLE);
        }
    }

    @Override
    public void loadError() {
        loadSir.showCallback(ErrorCallback.class);
    }

    @Override
    public void loadEmpty() {
        loadSir.showCallback(EmptyCallback.class);
    }

    @Override
    public void loadSuccess(List<WareHousingOrderBean.WareHousingBean> list) {
        loadSir.showCallback(SuccessCallback.class);
        wareHouseAdapter.setList(list);
    }

//    @Override
//    public void loadSuccess() {
//        loadSir.showCallback(SuccessCallback.class);
//    }
}
