package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "COMBO_ITEM".
*/
public class ComboItemDao extends AbstractDao<ComboItem, Long> {

    public static final String TABLENAME = "COMBO_ITEM";

    /**
     * Properties of entity ComboItem.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property ComId = new Property(1, Long.class, "comId", false, "COM_ID");
        public final static Property Fid = new Property(2, Long.class, "fid", false, "FID");
        public final static Property Qty = new Property(3, long.class, "qty", false, "QTY");
        public final static Property DiffAmt = new Property(4, double.class, "diffAmt", false, "DIFF_AMT");
        public final static Property SeqNo = new Property(5, long.class, "seqNo", false, "SEQ_NO");
        public final static Property Visible = new Property(6, long.class, "visible", false, "VISIBLE");
        public final static Property CreateTime = new Property(7, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property CreateBy = new Property(8, String.class, "createBy", false, "CREATE_BY");
        public final static Property UpdateTime = new Property(9, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property Conditions = new Property(10, long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRT = new Property(11, long.class, "isRT", false, "IS_RT");
        public final static Property Deletes = new Property(12, byte.class, "deletes", false, "DELETES");
        public final static Property PosId = new Property(13, long.class, "posId", false, "POS_ID");
        public final static Property Restaurant_id = new Property(14, long.class, "restaurant_id", false, "RESTAURANT_ID");
        public final static Property IsMainAccount = new Property(15, byte.class, "isMainAccount", false, "IS_MAIN_ACCOUNT");
        public final static Property PrintSeting = new Property(16, String.class, "printSeting", false, "PRINT_SETING");
    }


    public ComboItemDao(DaoConfig config) {
        super(config);
    }
    
    public ComboItemDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"COMBO_ITEM\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"COM_ID\" INTEGER," + // 1: comId
                "\"FID\" INTEGER," + // 2: fid
                "\"QTY\" INTEGER NOT NULL ," + // 3: qty
                "\"DIFF_AMT\" REAL NOT NULL ," + // 4: diffAmt
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 5: seqNo
                "\"VISIBLE\" INTEGER NOT NULL ," + // 6: visible
                "\"CREATE_TIME\" INTEGER," + // 7: createTime
                "\"CREATE_BY\" TEXT," + // 8: createBy
                "\"UPDATE_TIME\" INTEGER," + // 9: updateTime
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 10: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 11: isRT
                "\"DELETES\" INTEGER NOT NULL ," + // 12: deletes
                "\"POS_ID\" INTEGER NOT NULL ," + // 13: posId
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 14: restaurant_id
                "\"IS_MAIN_ACCOUNT\" INTEGER NOT NULL ," + // 15: isMainAccount
                "\"PRINT_SETING\" TEXT);"); // 16: printSeting
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"COMBO_ITEM\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, ComboItem entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long comId = entity.getComId();
        if (comId != null) {
            stmt.bindLong(2, comId);
        }
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
        stmt.bindLong(4, entity.getQty());
        stmt.bindDouble(5, entity.getDiffAmt());
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindLong(7, entity.getVisible());
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(8, createTime.getTime());
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(9, createBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(10, updateTime.getTime());
        }
        stmt.bindLong(11, entity.getConditions());
        stmt.bindLong(12, entity.getIsRT());
        stmt.bindLong(13, entity.getDeletes());
        stmt.bindLong(14, entity.getPosId());
        stmt.bindLong(15, entity.getRestaurant_id());
        stmt.bindLong(16, entity.getIsMainAccount());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(17, printSeting);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, ComboItem entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long comId = entity.getComId();
        if (comId != null) {
            stmt.bindLong(2, comId);
        }
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
        stmt.bindLong(4, entity.getQty());
        stmt.bindDouble(5, entity.getDiffAmt());
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindLong(7, entity.getVisible());
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(8, createTime.getTime());
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(9, createBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(10, updateTime.getTime());
        }
        stmt.bindLong(11, entity.getConditions());
        stmt.bindLong(12, entity.getIsRT());
        stmt.bindLong(13, entity.getDeletes());
        stmt.bindLong(14, entity.getPosId());
        stmt.bindLong(15, entity.getRestaurant_id());
        stmt.bindLong(16, entity.getIsMainAccount());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(17, printSeting);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public ComboItem readEntity(Cursor cursor, int offset) {
        ComboItem entity = new ComboItem( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // comId
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // fid
            cursor.getLong(offset + 3), // qty
            cursor.getDouble(offset + 4), // diffAmt
            cursor.getLong(offset + 5), // seqNo
            cursor.getLong(offset + 6), // visible
            cursor.isNull(offset + 7) ? null : new java.util.Date(cursor.getLong(offset + 7)), // createTime
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // createBy
            cursor.isNull(offset + 9) ? null : new java.util.Date(cursor.getLong(offset + 9)), // updateTime
            cursor.getLong(offset + 10), // conditions
            cursor.getLong(offset + 11), // isRT
            (byte) cursor.getShort(offset + 12), // deletes
            cursor.getLong(offset + 13), // posId
            cursor.getLong(offset + 14), // restaurant_id
            (byte) cursor.getShort(offset + 15), // isMainAccount
            cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16) // printSeting
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, ComboItem entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setComId(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setFid(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setQty(cursor.getLong(offset + 3));
        entity.setDiffAmt(cursor.getDouble(offset + 4));
        entity.setSeqNo(cursor.getLong(offset + 5));
        entity.setVisible(cursor.getLong(offset + 6));
        entity.setCreateTime(cursor.isNull(offset + 7) ? null : new java.util.Date(cursor.getLong(offset + 7)));
        entity.setCreateBy(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setUpdateTime(cursor.isNull(offset + 9) ? null : new java.util.Date(cursor.getLong(offset + 9)));
        entity.setConditions(cursor.getLong(offset + 10));
        entity.setIsRT(cursor.getLong(offset + 11));
        entity.setDeletes((byte) cursor.getShort(offset + 12));
        entity.setPosId(cursor.getLong(offset + 13));
        entity.setRestaurant_id(cursor.getLong(offset + 14));
        entity.setIsMainAccount((byte) cursor.getShort(offset + 15));
        entity.setPrintSeting(cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(ComboItem entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(ComboItem entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(ComboItem entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
