package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.ConsumeReasonBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/21/2021 10:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface WarehouseDetailsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        /**
         * 加載入庫信息和列表
         *
         * @param warehouseDetailsBean
         */
        void loadAdapter(List<WarehouseDetailsBean> warehouseDetailsBean);

        /**
         * 加載消耗原因
         *
         * @param consumeReasonBeans
         */
        void loadConsumeReason(List<ConsumeReasonBean> consumeReasonBeans);

        /**
         * 獲取頁面數據
         */
        void getPageInfo();

        /**
         * 修改庫存數量
         */
        void setWarehousingNum(int num);

        /**
         * 如果消耗成功了，需要移除消耗视图，显示流水
         *
         * @param visibility 是否显示流水
         */
        void showList(int visibility);

        /**
         * 打印消耗单
         *
         * @param consumeReasonDesc 消耗原因
         * @param consumptionNum    消耗数量
         */
        void printConsumeOrder(String consumeReasonDesc, int consumptionNum);

        /**
         * 跳转到sn码页面
         *
         * @param remark
         * @param sns
         */
        void jumpSnList(int foodQuantity, String remark, List<PurchaseFoodEncodeSn> sns);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<BaseResult> getWarehousingOrderDetails(Map<String, Object> map);

        Observable<BaseResult> getOutStockDetails(Map<String, Object> map);

        Observable<BaseResult> getWarehouseInventoryReason();

        /**
         * 庫存消耗
         *
         * @param requestBody
         * @return
         */
        Observable<BaseResult> consumeWareHousing(RequestBody requestBody);

        /**
         * 獲取庫存數量
         */
        Observable<BaseResult> getWarehousingNum(Map<String, Object> map);

        /**
         * 獲取Sn列表
         */
        Observable<BaseResult> querySnCodeList(Map<String, Object> map);

    }
}
