package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.OrderDetailsContract;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/22/2020 16:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class OrderDetailsModel extends BaseModel implements OrderDetailsContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderDetailsModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getOrderDetails(int orderId) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getOrderDetailsById(orderId);
    }

    @Override
    public Observable<BaseResult> addWarehouse(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).addWarehouse(requestBody);
    }

    @Override
    public Observable<BaseResult> upLoadPic(List<MultipartBody.Part> parts, Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).upLoadPic(parts, map);
    }

    @Override
    public Observable<BaseResult> deleteOrder(int orderId) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).deleteOrder(orderId);
    }

    @Override
    public Observable<BaseResult> querySnCodes(String encodeFoodNo, String encodeOrderNo) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).querySnCodes(encodeFoodNo, encodeOrderNo);
    }

    @Override
    public Observable<BaseResult> buyAgainByFoodIds(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).buyAgainByFoodIds(map);
    }
}