package com.gingersoft.gsa.cloud.download.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodBean;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FunctionBean;
import com.gingersoft.gsa.cloud.download.mvp.model.service.DownloadService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;
import com.gingersoft.gsa.cloud.download.mvp.contract.DownloadContract;
import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 17:59
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class DownloadModel extends BaseModel implements DownloadContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public DownloadModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<FunctionBean> downFunctionList() {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFunctionList();
    }

    @Override
    public Observable<FoodBean> downFoodList(String restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFoodList(restaurantId);
    }
}