package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.utils.FunctionDaoUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.contract.MainContract;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.FunctionAdapter;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import java.util.ArrayList;
import java.util.List;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 14:10
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MainPresenter extends BasePresenter<MainContract.Model, MainContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private List<Function> mList = new ArrayList<>();
    private FunctionAdapter mAdapter;


    @Inject
    public MainPresenter(MainContract.Model model, MainContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initAdapter(Context context) {
        initFunctionItem(context);
        if (mAdapter == null) {
            mAdapter = new FunctionAdapter(context, mList);
            mRootView.setFunctionAdapter(mAdapter);
        }
    }

    public void initItemClickListener(Context context) {
        mAdapter.setOnItemClickListener(new FunctionAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(int position) {

                String clas = mList.get(position).getResUrl();

                if (TextUtils.isEmpty(clas)) {
                    Intent intent = null;
                    try {
                        intent = new Intent(context, Class.forName(clas));
                        context.startActivity(intent);

                    } catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void initFunctionItem(Context context) {
        if (mList.size() > 0) {
            mList.clear();
        }

        FunctionDaoUtils functionDao = new FunctionDaoUtils(context);
        List<Function> functionList = functionDao.queryAllFunction();

        mList.addAll(functionList);
    }

}
