package com.joe.print.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;

import com.joe.print.LayoutToBitmapUtils;
import com.joe.print.R;
import com.joe.print.utils.ImageUtils;

import java.util.ArrayList;
import java.util.List;

import am.util.printer.PrintDataMaker;
import am.util.printer.PrinterUtils;
import am.util.printer.PrinterWriter;
import am.util.printer.PrinterWriter58mm;
import am.util.printer.PrinterWriter80mm;

/**
 * Created by Wyh on 2020/1/9.
 * 送單打印
 */
public class SendPrint implements PrintDataMaker {

    private Context context;
    private int parting = 255;//高度分割值，
    private int width; // 打印的圖片寬度,紙張寬度

    public SendPrint(Context context, int parting, int width) {
        this.context = context;
        this.parting = parting;
        this.width = width;
    }

    @Override
    public List<byte[]> getPrintData(int type) {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = type == PrinterWriter58mm.TYPE_58 ? new PrinterWriter58mm(parting, width) : new PrinterWriter80mm(parting, width);
            printer.setAlignCenter();
            data.add(printer.getDataAndReset());

            View view = LinearLayout.inflate(context, R.layout.print_layout_print, null);
            LayoutToBitmapUtils.layoutView(context, view);//先测量
            Bitmap bitmap = LayoutToBitmapUtils.loadBitmapFromView(view);//轉bitmap
            ArrayList<byte[]> image1 = PrinterUtils.decodeBitmapToDataList(ImageUtils.zoomDrawable(bitmap, width, bitmap.getHeight()), parting);
            data.addAll(image1);

            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }
}
