package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;

import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.table.di.component.DaggerInputTableComponent;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.InputTableContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.InputTablePresenter;
import com.gingersoft.gsa.cloud.table.R;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnLongClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:32
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class InputTableFragment extends BaseFragment<InputTablePresenter> implements InputTableContract.View {

    @BindView(R.id.ed_value)
    EditText ed_value;

    @BindView(R.id.btn_0)
    Button btn_0;
    @BindView(R.id.btn_1)
    Button btn_1;
    @BindView(R.id.btn_2)
    Button btn_2;
    @BindView(R.id.btn_3)
    Button btn_3;
    @BindView(R.id.btn_4)
    Button btn_4;
    @BindView(R.id.btn_5)
    Button btn_5;
    @BindView(R.id.btn_6)
    Button btn_6;
    @BindView(R.id.btn_7)
    Button btn_7;
    @BindView(R.id.btn_8)
    Button btn_8;
    @BindView(R.id.btn_9)
    Button btn_9;
    @BindView(R.id.btn_clear)
    Button btn_clear;
    @BindView(R.id.btn_A)
    Button btn_A;
    @BindView(R.id.btn_B)
    Button btn_B;
    @BindView(R.id.btn_C)
    Button btn_C;
    @BindView(R.id.btn_more)
    Button btn_more;
    @BindView(R.id.btn_right)
    Button btn_right;

    private TableActivity mActivity;
    private List<TableBean.DataBean> mTableList = new ArrayList<>();

    private String t_name = "";
    private String t_splite = "";

    private boolean isClose = false;
    private boolean isFirstNumberClick = true;
    private String inputstr = "";
    private String letter = "-ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int letterindex;
    private boolean Splitemodal = false;
    private boolean keystatestand = false;


    public static InputTableFragment newInstance() {
        InputTableFragment fragment = new InputTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerInputTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_input_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        mActivity = (TableActivity) getActivity();


    }

    private void initDefalutText() {
        if (letter.length() > 1)
            btn_A.setText(letter.substring(0, 1));
        if (letter.length() > 2)
            btn_B.setText(letter.substring(1, 2));
        if (letter.length() > 3)
            btn_C.setText(letter.substring(2, 3));

        if (btn_A.getText().equals("-")) {
            btn_A.setTag(97);
        } else {
            btn_A.setTag(55);
        }
        if (btn_B.getText().equals("-")) {
            btn_B.setTag(97);
        } else {
            btn_B.setTag(56);
        }

        if (btn_C.getText().equals("-")) {
            btn_C.setTag(97);
        } else {
            btn_C.setTag(57);
        }

        btn_more.setText("…");

        ed_value.setText("");
        t_name = "";
        ed_value.setHint("please input table");
    }

    @OnLongClick({R.id.btn_clear})
    public boolean clearClick() {
        inputstr = "";
        ed_value.setText(inputstr);
        t_name = "";
//        GSAApplication.tableContract.setTableno("");
        return false;
    }

    @OnClick({R.id.btn_0, R.id.btn_1, R.id.btn_2, R.id.btn_3, R.id.btn_4, R.id.btn_5, R.id.btn_6, R.id.btn_7, R.id.btn_8
            , R.id.btn_9, R.id.btn_A, R.id.btn_B, R.id.btn_C, R.id.btn_more, R.id.btn_right, R.id.btn_clear})
    public void onClick(View v) {

        int i = Integer.parseInt(v.getTag().toString());
        Button btn = (Button) v;
        String s = btn.getText().toString();
        VibratorUtils.pressButtonSound(getActivity());

//        GSAApplication.tableContract.setIsSplite(false);
//        GSAApplication.tableContract.setTableno_split("");

        switch (i) {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
                if (isFirstNumberClick == true) {
                    isFirstNumberClick = false;
                    inputstr = "";
                    t_splite = "";
                    Splitemodal = false;
                }
                inputstr = inputstr + s;
                ed_value.setText(inputstr);
//                GSAApplication.tableContract.setTableno(inputstr);
                if (Splitemodal) {
                    t_splite = t_splite + s;
                } else {
                    t_name = t_name + s;
                }
                break;
            case 55:
            case 56:
            case 57:
                if (isFirstNumberClick == true) {
                    isFirstNumberClick = false;
                    inputstr = "";
                    t_splite = "";
                    Splitemodal = false;
                }
                if (((Button) v).getText() != " ") {
                    inputstr = inputstr + ((Button) v).getText();
                    ed_value.setText(inputstr);
                    if (Splitemodal) {
                        t_splite = t_splite + s;
                    } else {
                        t_name = t_name + s;
                    }
                }
                break;
            case 58:
                setKeystate();
                break;
            case 97://"-"号
                Splitemodal = true;

                //同时写入"-"号
                inputstr = inputstr + "-";
                t_splite = "";
                ed_value.setText(inputstr);
                break;
            case 98: //√
                t_name = ed_value.getText().toString();

                goToMealStandBefore();

                inputstr = "";
                ed_value.setText("");
                break;
            case 99: //clear button
                if (inputstr.length() > 0) {
                    String sr = inputstr.substring(inputstr.length() - 1, inputstr.length());
                    //将获取到的sr进行对比
                    String ss = "";
                    if (sr.equals("-")) {
                        Splitemodal = false;
                    }
                    if (Splitemodal) {
                        ss = t_name.substring(t_name.length() - 1, t_name.length());
                        if (t_splite.length() > 0) {
                            String ss1 = t_splite.substring(t_splite.length() - 1, t_splite.length());
                            if (ss1.equals(sr)) {
                                t_splite = t_splite.substring(0, t_splite.length() - 1);
                            }
                        }
                    } else {
                        if (ss.equals(sr)) {
                            t_name = t_name.substring(0, t_name.length() - 1);
                        }
                    }
                    inputstr = inputstr.substring(0, inputstr.length() - 1);
                    ed_value.setText(inputstr);
//                    if (inputstr.length() > 0) {
//                        GSAApplication.tableContract.setTableno(inputstr);
//                    } else {
//                        GSAApplication.tableContract.setTableno("");
//                    }
                }
                break;
        }
    }

    private void goToMealStandBefore() {
        if (Splitemodal) {
            Splitemodal = false;
            load_meal_before_splite();
            return;
        }

        int id = getTableIdByName(t_name);
        mActivity.clickTableItem(id);
    }

    private void load_meal_before_splite() {
        t_name = t_name.substring(0, t_name.indexOf("-"));
//        showLoading(LanguageUtils.get_language_system(getActivity(), "comm.gettabledata", "get tabledata-now"));
//
//        mActivity.toOpen(this);
    }

    public void setKeystate() {
        if (keystatestand) {
            //正常情况下的：
            btn_0.setText("0");
            btn_1.setText("1");
            btn_2.setText("2");
            btn_3.setText("3");
            btn_4.setText("4");
            btn_5.setText("5");
            btn_6.setText("6");
            btn_7.setText("7");
            btn_8.setText("8");
            btn_9.setText("9");
            if (letter.length() > 1)
                btn_A.setText(letter.substring(0, 1));
            if (letter.length() > 2)
                btn_B.setText(letter.substring(1, 2));
            if (letter.length() > 3)
                btn_C.setText(letter.substring(2, 3));
        } else {
            //按下btn_more情况下的：
            if (letter.length() > 4)
                btn_A.setText(letter.substring(3, 4));
            if (letter.length() > 5)
                btn_7.setText(letter.substring(4, 5));
            if (letter.length() > 6)
                btn_8.setText(letter.substring(5, 6));
            if (letter.length() > 7)
                btn_9.setText(letter.substring(6, 7));
            if (letter.length() > 8)
                btn_B.setText(letter.substring(7, 8));
            if (letter.length() > 9)
                btn_4.setText(letter.substring(8, 9));
            if (letter.length() > 10)
                btn_5.setText(letter.substring(9, 10));
            if (letter.length() > 11)
                btn_6.setText(letter.substring(10, 11));
            if (letter.length() > 12)
                btn_C.setText(letter.substring(11, 12));
            if (letter.length() > 13)
                btn_1.setText(letter.substring(12, 13));
            if (letter.length() > 14)
                btn_2.setText(letter.substring(13, 14));
            if (letter.length() > 15)
                btn_3.setText(letter.substring(14, 15));
            if (letter.length() > 16)
                btn_0.setText(letter.substring(15, 16));

            if (btn_A.getText().equals("-")) {
                btn_A.setTag(97);
            } else {
                btn_A.setTag(55);
            }
            if (btn_B.getText().equals("-")) {
                btn_B.setTag(97);
            } else {
                btn_B.setTag(56);
            }
            if (btn_C.getText().equals("-")) {
                btn_C.setTag(97);
            } else {
                btn_C.setTag(57);
            }
        }

        keystatestand = !keystatestand;
    }


    @Override
    public void setData(@Nullable Object data) {
        if (data != null && data instanceof Message) {
            switch (((Message) data).what) {
                case 0:
                    break;
                case 1://刷新全部数据
                    List<TableBean.DataBean> datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    mTableList.clear();
                    mTableList.addAll(datasBeans);
                    break;
                default:
                    //do something
                    break;
            }
        }
    }

    private int getTableIdByName(String name) {
        for (int i = 0; i < mTableList.size(); i++) {
            TableBean.DataBean dataBean = mTableList.get(i);
            if (dataBean.getTableName().equals(name)) {
                return dataBean.getId();
            }
        }
        return -1;
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
