package com.gingersoft.gsa.cloud.common.core.order.bean.request;

import com.gingersoft.gsa.cloud.common.core.order.billItem.DiscountItem;
import com.gingersoft.gsa.cloud.common.core.order.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.common.core.order.discount.NomalDiscount;
import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-11-11
 * @update date: 2020-11-11
 * @description:
 */
@Data
public class OrderDiscountRequest {


    public static final byte ORDER_DISCOUNT = 0;
    public static final byte MEMBER_DISCOUNT = 1;
    public static final byte COUPON_DISCOUNT = 2;

    /**
     * 0#餐廳折扣
     * 1#會員折扣
     * 2#优惠券折扣
     */
    private byte type;
    /**
     * 折扣ID
     */
    private Long discountId;
    /**
     * 會員折扣ID
     */
    private Long memberId;
    /**
     * 會員折扣比例
     */
    private Integer memberDiscountRate;
    /**
     * 折扣金額
     */
    private double discountAmount;
    /**
     * 是否计算服务费
     */
    private int scAble;

    public static OrderDiscountRequest orderDiscountTransRequest(DiscountItem discount) {
        OrderDiscountRequest request = new OrderDiscountRequest();
        request.setType(ORDER_DISCOUNT);
        if(discount.getDiscount() != null) {
            NomalDiscount discount1 = (NomalDiscount) discount.getDiscount();
            request.setDiscountId(discount1.getDiscount().getId());
        }
        request.setDiscountAmount(discount.getMoney());
        request.setScAble(0);
        return request;
    }

    public static OrderDiscountRequest memberDiscountTransRequest(DiscountItem discount) {
        OrderDiscountRequest request = new OrderDiscountRequest();
        request.setType(MEMBER_DISCOUNT);
        if(discount.getDiscount() != null) {
            MemberDiscount memberDiscount = (MemberDiscount) discount.getDiscount();
            request.setMemberId(memberDiscount.getMemberDiscount().getId());
//                request.setMemberDiscountRate((int) memberDiscount.getDiscount().getDiscount_value());
        }
        request.setDiscountAmount(discount.getMoney());
        request.setScAble(0);
        return request;
    }

    public static OrderDiscountRequest couponDiscountTransRequest(DiscountItem discount) {
        OrderDiscountRequest request = new OrderDiscountRequest();
        request.setType(COUPON_DISCOUNT);
        if(discount.getDiscount() != null) {
//                request.setMemberId(discount.getDiscount().getMemberId());
//                request.setDiscountId(discount.getDiscount().getId());
//                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
        }
        request.setDiscountAmount(discount.getMoney());
        request.setScAble(0);
        return request;
    }
}
