package com.gingersoft.gsa.cloud.common.core.order.billItem;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;

/**
 * @author : bin
 * @create date: 2020-10-14
 * @update date: 2020-10-14
 * @description:服務費項
 */
public class ServiceChargeItem extends BillItem {

    public ServiceChargeItem(String name) {
        super(name,BillItem.BILL_ITEM_ORDER_SENT_STATUS);
    }

    public double updateBillItem(double wholeAmount, int serviceCharge) {
        int itemDecimals = GsaCloudApplication.functionConfiguration.getItemDecimalsVaule();
        double serviceAmount = MoneyUtil.divide(MoneyUtil.multiply(wholeAmount, serviceCharge).doubleValue(), 100, itemDecimals);
        if (serviceAmount > 0) {
            setMoney(MoneyUtil.get_ItemDecimals_money(serviceAmount));
        }
        return MoneyUtil.get_ItemDecimals_money(MoneyUtil.sum(wholeAmount, serviceAmount));
    }
}
