package com.gingersoft.gsa.cloud.common.core.print.bean.base;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-01
 * @update date: 2020-12-01
 * @description:食品打印實體
 */
@Data
public class PrintFoodItem implements Parcelable {

    private String name;
    private int num;
    private double price;
    private int itemType;

    public PrintFoodItem(String name, int num, double price, int itemType) {
        this.name = name;
        this.num = num;
        this.price = price;
        this.itemType = itemType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.num);
        dest.writeDouble(this.price);
        dest.writeInt(this.itemType);
    }

    protected PrintFoodItem(Parcel in) {
        this.name = in.readString();
        this.num = in.readInt();
        this.price = in.readDouble();
        this.itemType = in.readInt();
    }

    public static final Creator<PrintFoodItem> CREATOR = new Creator<PrintFoodItem>() {
        @Override
        public PrintFoodItem createFromParcel(Parcel source) {
            return new PrintFoodItem(source);
        }

        @Override
        public PrintFoodItem[] newArray(int size) {
            return new PrintFoodItem[size];
        }
    };
}
