package com.gingersoft.gsa.cloud.common.core.restaurant;

import android.text.TextUtils;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.common.core.user.UserConstans;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:品牌餐廳信息管理lei
 */
public class ResturantInfoManager {

    private static ResturantInfoManager sResturantInfoManager = null;

    /**
     * 品牌信息
     */
    private BrandInfo brandInfo;
    /**
     * 餐廳信息
     */
    private RestaurantInfo restaurantInfo;

    private ResturantInfoManager() {
        if (brandInfo == null) {
            brandInfo = new BrandInfo();
        }
        if (restaurantInfo == null) {
            restaurantInfo = new RestaurantInfo();
        }
        brandInfo.setBrandId((Integer) SPUtils.get(UserConstans.brandId, 0));
        brandInfo.setBrandName((String) SPUtils.get(UserConstans.brandName, ""));
        restaurantInfo.setGsPosShopId((String) SPUtils.get(UserConstans.gsPosShopId, "-1"));
        restaurantInfo.setRestaurantId((Integer) SPUtils.get(UserConstans.restaurantId, 0));
        restaurantInfo.setRestaurantName((String) SPUtils.get(UserConstans.restaurantName, ""));
    }

    public static ResturantInfoManager newInstance() {
        if (sResturantInfoManager == null) {
            sResturantInfoManager = new ResturantInfoManager();
        }
        return sResturantInfoManager;
    }

    public int getRestaurantId() {
        if (restaurantInfo != null) {
            return restaurantInfo.getRestaurantId();
        }
        return (int) SPUtils.get(UserConstans.restaurantId, 0);
    }

    public String getGsPosShopId() {
        if (restaurantInfo != null) {
            return restaurantInfo.getGsPosShopId();
        }
        return (String) SPUtils.get(UserConstans.gsPosShopId, "-1");
    }

    public String getRestaurantName() {
        if (restaurantInfo != null) {
            return restaurantInfo.getRestaurantName();
        }
        return (String) SPUtils.get(UserConstans.restaurantName, "");
    }

    public int getBrandId() {
        if (brandInfo != null) {
            return brandInfo.getBrandId();
        }
        return (int) SPUtils.get(UserConstans.brandId, 0);
    }

    public String getBrandName() {
        if (brandInfo != null) {
            return brandInfo.getBrandName();
        }
        return (String) SPUtils.get(UserConstans.brandName, "");
    }

    public void setResturantInfo(RestaurantInfo info) {
        if (info == null) {
            return;
        }
        this.restaurantInfo = info;
        SPUtils.put(UserConstans.gsPosShopId, info.getGsPosShopId());
        SPUtils.put(UserConstans.restaurantId, info.getRestaurantId());
        SPUtils.put(UserConstans.restaurantName, info.getRestaurantName());
    }

    public void setBrandInfo(BrandInfo info) {
        if (info == null) {
            return;
        }
        this.brandInfo = info;
        SPUtils.put(UserConstans.brandId, info.getBrandId());
        SPUtils.put(UserConstans.brandName, info.getBrandName());
    }

    public void removeResturantInfo() {
        this.restaurantInfo = null;
        SPUtils.remove(UserConstans.gsPosShopId);
        SPUtils.remove(UserConstans.restaurantId);
        SPUtils.remove(UserConstans.restaurantName);
    }

    public void removeBrandInfo() {
        this.brandInfo = null;
        SPUtils.remove(UserConstans.gsPosShopId);
        SPUtils.remove(UserConstans.restaurantId);
        SPUtils.remove(UserConstans.restaurantName);
        SPUtils.remove(UserConstans.brandRestaurantInfos);
    }

    public static String getBrandRestaurantInfos() {
        return (String) SPUtils.get(UserConstans.brandRestaurantInfos, "");
    }

    public static void putBrandRestaurantInfos(String brandRestaurantIds) {
        if (TextUtils.isEmpty(brandRestaurantIds)) {
            return;
        }
        SPUtils.put(UserConstans.brandRestaurantInfos, brandRestaurantIds);
    }

}
