package com.gingersoft.gsa.cloud.common.ui.adapter.multi;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use:
 */
public class InputProvider extends MyBaseItemProvider {

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_TYPE_INPUT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_input;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, InfoMultiBean infoMultiBean) {
        super.convert(baseViewHolder, infoMultiBean);
        EditText editText = baseViewHolder.getView(R.id.ed_food_menu_value);
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowValue())) {
            editText.setText(infoMultiBean.getShowValue());
        } else {
            editText.setHint(infoMultiBean.getHintText());
            editText.setText("");
        }
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                List<InfoMultiBean> data = getAdapter().getData();
                data.get(baseViewHolder.getAdapterPosition()).setShowValue(s + "");
            }
        });
        editText.setInputType(infoMultiBean.getInputType());
    }
}
