package com.gingersoft.coldchain_module.mvp.presenter;

import android.app.Application;

import com.gingersoft.coldchain_module.mvp.constans.ColdChainConstants;
import com.gingersoft.coldchain_module.mvp.contract.OrderDetailsContract;
import com.gingersoft.coldchain_module.mvp.model.bean.CancelLogisticsBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ReadBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ThirdItem;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.utils.FileUtils;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.core.print.bean.OrderDetails;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;


@ActivityScope
public class OrderDetailsPresenter extends BasePresenter<OrderDetailsContract.Model, OrderDetailsContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public OrderDetailsPresenter(OrderDetailsContract.Model model, OrderDetailsContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void findOrderDetails(int orderId, int isRead) {
        //startTime  endTime  //mRootView.showLoading("獲取訂單詳情...")  mRootView.hideLoading()
        RequestBody requestBody = new FormBody.Builder()
                .add("orderId", orderId + "")
                .build();
        mModel.findOrderDetails(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> {
                })
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<OrderDetails>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull OrderDetails info) {
                        if (info != null) {
                            if (info.getData() != null && info.getData().size() > 0) {
                                mRootView.loadOrderDetails(info.getData().get(0));
                                if (isRead == 0) {
                                    setIsRead(info.getData().get(0).getID());
                                }
                            } else {
                                if (TextUtil.isNotEmptyOrNullOrUndefined(info.getErrorMsg())) {
                                    mRootView.showMessage(info.getErrorMsg());
                                } else {
                                    mRootView.showMessage("獲取訂單詳情失敗");
                                    mRootView.killMyself();
                                }
                            }
                        } else {
                            mRootView.showMessage("獲取訂單詳情失敗");
                            mRootView.killMyself();
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showMessage("獲取訂單詳情失敗");
                        mRootView.killMyself();
                    }
                });
    }

    public void setIsRead(int orderId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("id", orderId + "")
                .build();
        mModel.setIsRead(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> {
                })
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<ReadBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull ReadBean info) {
                        mRootView.updateOrderState(ColdChainConstants.ORDER_READ);
                    }
                });
    }

    public void thirdDelivery(OrderDetails.DataBean dataBean) {
        ThirdItem third = new ThirdItem();
        if (dataBean.getPRODUCT_NAME() != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean productnameBean : dataBean.getPRODUCT_NAME()) {
                ThirdItem.ThirdItemItem.UntPrice hkd = new ThirdItem.ThirdItemItem.UntPrice("HKD", Double.valueOf(productnameBean.getPRICE()));
                ThirdItem.ThirdItemItem thirdItemItem;

                if (TextUtil.isNotEmptyOrNullOrUndefined(productnameBean.getPRODUCT_NAME())) {
                    thirdItemItem = new ThirdItem.ThirdItemItem(productnameBean.getPRODUCT_NAME(), hkd);
                } else {
                    thirdItemItem = new ThirdItem.ThirdItemItem("", hkd);
                }
                third.add(thirdItemItem);
            }
        }
        RequestBody requestBody = new FormBody.Builder()
                .add("orderId", dataBean.getID() + "")
                .add("items", GsonUtils.GsonString(third))
                .build();
        mModel.thirdDelivery(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("確認訂單中，請稍候..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<ShipAnyOrdersNewBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull ShipAnyOrdersNewBean info) {
                        if (info != null) {
                            if (info.isSuccess()) {
                                //修改訂單狀態
                                updateOrderState(dataBean, ColdChainConstants.ORDER_CONFIRMED, info.getData().getLab_url());
                            } else {
                                if (TextUtil.isNotEmptyOrNullOrUndefined(info.getErrMsg())) {
                                    mRootView.showMessage(info.getErrMsg());
                                } else {
                                    mRootView.showMessage("確認訂單失敗");
                                }
                                mRootView.killMyself();
                            }
                        } else {
                            mRootView.showMessage("服務器錯誤");
                            mRootView.killMyself();
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showMessage("服務器錯誤");
                        mRootView.killMyself();
                    }
                });
    }

    public void updateOrderState(OrderDetails.DataBean dataBean, int status, String labUrl) {
        //添加PRJ
        addPrj(dataBean);
        RequestBody requestBody = new FormBody.Builder()
                .add("memberId", UserContext.newInstance().getMemberId() + "")
                .add("orderId", dataBean.getID() + "")
                .add("status", status + "")
                .add("", UserContext.newInstance().getMemberName() + "")
                .build();
        mModel.updateOrderStatus(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("確認訂單中，請稍候..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<UpdateOrderStatusBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull UpdateOrderStatusBean info) {
                        if (info != null) {
                            if (TextUtil.isNotEmptyOrNullOrUndefined(info.getErrorMsg())) {
                                mRootView.showMessage(info.getErrorMsg());
                            }
                            if (status == ColdChainConstants.ORDER_CONFIRMED) {
                                //模擬獲取到PDF，進行打印
                                mRootView.updateOrderState(status);
                                if (TextUtil.isNotEmptyOrNullOrUndefined(labUrl)) {
                                    //下載打印文件
                                    download(dataBean.getID(), labUrl);
                                } else {
                                    mRootView.showMessage("未獲取到物流單下載鏈接，無法打印");
                                    mRootView.killMyself();
                                }
                            } else {
                                mRootView.killMyself();
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showMessage(t.getMessage());
                        mRootView.killMyself();
                    }
                });
    }

    public void addPrj(OrderDetails.DataBean dataBean) {
        StringBuffer ids = new StringBuffer();
        if (dataBean.getPRODUCT_NAME() != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean productnameBean : dataBean.getPRODUCT_NAME()) {
                if (productnameBean.getChild() != null) {
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : productnameBean.getChild()) {
                        if (childBeanX != null) {
                            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                                ids.append(childBean.getOdsId());
                                ids.append(",");
                            }
                        }
                        ids.append(childBeanX.getOdsId());
                        ids.append(",");
                    }
                }
                ids.append(productnameBean.getOdsId());
                ids.append(",");
            }
            RequestBody requestBody = new FormBody.Builder()
                    .add("orderId", dataBean.getID() + "")
                    .add("restaurantId", ResturantInfoManager.newInstance().getRestaurantId() + "")
                    .add("orderDetailsIds", ids.toString())
                    .build();
            mModel.addPrj(requestBody);
        }
    }

    public void download(int orderId, String url) {
        try {
            updatePrintPdfStatus(orderId);
            Disposable download_success = Observable.create((ObservableOnSubscribe<File>) emitter -> {
                OkHttpClient client = new OkHttpClient.Builder().build();
                Request request = new Request.Builder()
                        .url(url)
                        .get()
                        .build();
                client.newCall(request).enqueue(new Callback() {
                    @Override
                    public void onFailure(Call call, IOException e) {

                    }

                    @Override
                    public void onResponse(Call call, Response response) {
                        InputStream is = null;
                        byte[] buf = new byte[2048];
                        int len = 0;
                        FileOutputStream fos = null;
                        // 储存下载文件的目录
                        FileUtils.makeDirs(FileUtils.File_PATH);
                        try {
                            is = response.body().byteStream();
                            long total = response.body().contentLength();
                            File file = new File(FileUtils.File_PATH, url.substring(url.lastIndexOf("/") + 1));
                            fos = new FileOutputStream(file);
                            long sum = 0;
                            while ((len = is.read(buf)) != -1) {
                                fos.write(buf, 0, len);
                                sum += len;
                                int progress = (int) (sum * 1.0f / total * 100);
                                mRootView.showLoading("下載打印文檔中" + progress + "%");
                                LogUtil.e(TAG, "download progress : " + progress);
                            }
                            emitter.onNext(file);
                            fos.flush();
                            LogUtil.e(TAG, "download success");
                        } catch (Exception e) {
                            e.printStackTrace();
                            LogUtil.e(TAG, "download failed : " + e.getMessage());
                        } finally {
                            try {
                                if (is != null)
                                    is.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                            try {
                                if (fos != null)
                                    fos.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                });
            }).subscribeOn(Schedulers.io())
                    .doOnSubscribe(disposable -> {
                        mRootView.showLoading("下載打印文檔中，請稍候...");
                    })
                    .subscribeOn(AndroidSchedulers.mainThread())
                    .observeOn(AndroidSchedulers.mainThread())
                    .doAfterTerminate(() -> {
                    })
                    .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                    .subscribe(file -> mRootView.printLogisticsList(file));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelOrder(int orderId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("memberId", UserContext.newInstance().getMemberId() + "")
                .add("orderId", orderId + "")
                .add("status", "6")
                .add("", UserContext.newInstance().getMemberName())
                .build();
        mModel.updateOrderStatus(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("取消訂單中，請稍候..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<UpdateOrderStatusBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull UpdateOrderStatusBean info) {
                        if (info != null) {
                            if (TextUtil.isNotEmptyOrNullOrUndefined(info.getErrorMsg())) {
                                mRootView.showMessage(info.getErrorMsg());
                            }
                            mRootView.updateOrderState(ColdChainConstants.ORDER_CANCELLED);
                            mRootView.killMyself();
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.killMyself();
                    }
                });
    }

    public void cancelOrderAndLogistics(int orderId) {
        cancelLogistics(orderId, true);
    }

    public void cancelLogistics(int orderId, boolean isCancelOrder) {
        RequestBody requestBody = new FormBody.Builder()
                .add("restaurantId", ResturantInfoManager.newInstance().getRestaurantId() + "")
                .add("orderId", orderId + "")
                .add("reasonId", "")
                .add("reasonDesc", "")
                .build();
        mModel.cancelLogistics(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("取消物流中，請稍候..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<CancelLogisticsBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull CancelLogisticsBean info) {
                        if (info != null) {
                            if (info.isSuccess()) {
                                mRootView.updateOrderState(ColdChainConstants.LOGISTICS_CANCELLED);
                                if (isCancelOrder) {
                                    cancelOrder(orderId);
                                } else {
                                    mRootView.showMessage("物流已取消");
                                    mRootView.killMyself();
                                }
                            } else {
                                if (TextUtil.isNotEmptyOrNullOrUndefined(info.getErrMsg())) {
                                    mRootView.showMessage(info.getErrMsg());
                                } else {
                                    mRootView.showMessage("取消物流失敗");
                                }
                            }
                        } else {
                            mRootView.showMessage("取消物流失敗");
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showMessage("取消物流失敗");
                        mRootView.killMyself();
                    }
                });
    }

    public void updatePrintPdfStatus(int orderId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("orderId", orderId + "")
                .add("isPrint", "1")
                .build();
        mModel.updatePrintPdfStatus(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> { })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        mRootView.setPrintPdfState();
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.killMyself();
                    }
                });
    }

}
