package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.common.ui.adapter.multi.InfoMultiAdapter;
import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.common.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerNewSupplierComponent;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.gingersoft.supply_chain.mvp.contract.NewSupplierContract;
import com.gingersoft.supply_chain.mvp.presenter.NewSupplierPresenter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;
import static com.gingersoft.supply_chain.mvp.ui.fragment.SupplierListFragment.SUPPLIER_LIST;


/**
 * ================================================
 * Description:新增或編輯供應商
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 18:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NewSupplierFragment extends BaseSupplyChainFragment<NewSupplierPresenter> implements NewSupplierContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_supplier_info)
    QMUITopBar topbarSupplierInfo;
    @BindView(R2.id.rv_supplier_info)
    RecyclerView rvSupplierInfo;
    @BindView(R2.id.btn_save_supplier)
    QMUIAlphaButton btnSaveSupplier;

    private SupplierInfoBean supplierBean;
    private boolean isUpdate = false;
    private final static String SUPPLIER_INFO_KEY = "supplier_info_key";

    private InfoMultiAdapter infoMultiAdapter;

    public static NewSupplierFragment newInstance(SupplierInfoBean supplierBean) {
        NewSupplierFragment fragment = new NewSupplierFragment();
        if (supplierBean != null) {
            Bundle bundle = new Bundle();
            bundle.putSerializable(SUPPLIER_INFO_KEY, supplierBean);
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerNewSupplierComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_new_supplier, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            supplierBean = (SupplierInfoBean) arguments.getSerializable(SUPPLIER_INFO_KEY);
        }
        initTopBar();

        List<InfoMultiBean> infoMultiBeans = new ArrayList<>();
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_LINE));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_TITLE, "基本信息"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "供應商編號", false, "請輸入編號-默認GYS001"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "名稱", true, "請輸入名稱"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "聯繫人", true, "請輸入聯繫人"));
        InfoMultiBean phoneBean = new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "聯繫人電話", true, "請輸入聯繫人電話");
        phoneBean.setInputType(EditorInfo.TYPE_CLASS_PHONE);
        infoMultiBeans.add(phoneBean);
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "詳細地址", true, "請輸入詳細地址"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_LINE));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_TITLE, "接收方式"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "Email", false, "請輸入Email"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "座機", false, "請輸入座機"));

        InfoMultiBean receivingMode = new InfoMultiBean(InfoMultiBean.ITEM_TYPE_SHOW_LIST, "接收軟件", false, "", "選擇");
        List<InfoMultiBean> childInfoMulti = new ArrayList<>();
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "WhatsApp", false, "請輸入WhatsApp"));
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "WeChat", false, "請輸入WeChat"));
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "Line", false, "請輸入Line"));
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "Kakao Talk", false, "請輸入Kakao Talk"));
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "SMS", false, "請輸入SMS"));
        childInfoMulti.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, "Efax", false, "請輸入Efax"));
        receivingMode.setInfoMultiBeans(childInfoMulti);
        infoMultiBeans.add(receivingMode);
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_LINE));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_TITLE, "備註"));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_INPUT, null, false, "請輸入備註"));
        if (supplierBean != null) {
            infoMultiBeans.get(2).setShowValue(supplierBean.getSupplierNo());
            infoMultiBeans.get(3).setShowValue(supplierBean.getSupplierName());
            infoMultiBeans.get(4).setShowValue(supplierBean.getContacts());
            infoMultiBeans.get(5).setShowValue(supplierBean.getContactInformation());
            infoMultiBeans.get(6).setShowValue(supplierBean.getAddress());
            infoMultiBeans.get(14).setShowValue(supplierBean.getRemarks());
        }
        infoMultiAdapter = new InfoMultiAdapter(mContext, infoMultiBeans);
        rvSupplierInfo.addItemDecoration(new DividerItemDecoration(mContext, VERTICAL_LIST));
        rvSupplierInfo.setAdapter(infoMultiAdapter);
    }

    private void initTopBar() {
        if (supplierBean != null) {
            isUpdate = true;
            topbarSupplierInfo.addRightImageButton(R.drawable.ic_white_delete, R.id.topbar_right_delete_button).setOnClickListener(this);
            topbarSupplierInfo.setTitle("編輯供應商");
        } else {
            topbarSupplierInfo.setTitle("新增供應商");
        }
        topbarSupplierInfo.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

    @OnClick({R2.id.btn_save_supplier})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_delete_button) {
            //刪除供應商
            new AppDialog().showWaringDialog(mContext, "刪除供應商", (view1, dialog) -> {
                dialog.dismiss();
                supplierBean.setDeletes(1);
                mPresenter.updateSupplier(supplierBean);
            });
        } else if (viewId == R.id.btn_save_supplier) {
            //保存
            if (isUpdate) {
                mPresenter.updateSupplier(mPresenter.getSupplierInfo(infoMultiAdapter.getData(), supplierBean));
            } else {
                mPresenter.addSupplier(mPresenter.getSupplierInfo(infoMultiAdapter.getData(), supplierBean));
            }
        }
    }

    @Override
    public void saveSuccess() {
        setFragmentResult(SUPPLIER_LIST, null);
        killMyself();
    }
}
