package com.gingersoft.gsa.cloud.common.core.order.billItem;

import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;

/**
 * @author : bin
 * @create date: 2020-10-14
 * @update date: 2020-10-14
 * @description:賬單小數項
 */
public class RoundingItem extends BillItem {

    public RoundingItem(String name) {
        super(BillItem.ROUNDING_TYPE, name);
    }

    public double updateBillItem(double totalAmount) {
        double m2 = MoneyUtil.getOrderRounding(totalAmount);
        double roundingMoney = 0.0;
        if (m2 != 0) {
            roundingMoney = MoneyUtil.sub(m2, MoneyUtil.get_ItemDecimals_money(totalAmount));
        }
        if (roundingMoney != 0.0) {
            setMoney(MoneyUtil.get_ItemDecimals_money(roundingMoney));
        }
        return MoneyUtil.get_ItemDecimals_money(MoneyUtil.sum(totalAmount,roundingMoney));
    }

}
