package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.ui.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerMeasurementUnitComponent;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.contract.MeasurementUnitContract;
import com.gingersoft.supply_chain.mvp.presenter.MeasurementUnitPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.MeasurementUnitAdapter;
import com.jess.arms.di.component.AppComponent;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description: 食材單位列表頁面
 * <p>
 * Created by MVPArmsTemplate on 11/21/2020 14:22
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MeasurementUnitFragment extends BaseSupplyChainFragment<MeasurementUnitPresenter> implements MeasurementUnitContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_measurement_unit_list)
    QMUITopBar topbarMeasurementUnitList;
    @BindView(R2.id.ed_measurement_unit_search)
    EditText edMeasurementUnitSearch;
    @BindView(R2.id.btn_measurement_unit_search)
    QMUIAlphaButton btnMeasurementUnitSearch;
    @BindView(R2.id.layout_measurement_unit_search)
    LinearLayout layoutMeasurementUnitSearch;
    @BindView(R2.id.rv_measurement_unit_list)
    RecyclerView rvMeasurementUnitList;
    @BindView(R2.id.btn_new_measurement_unit)
    QMUIAlphaButton btnNewMeasurementUnit;
    @BindView(R2.id.srl_measurement)
    SmartRefreshLayout smartRefreshLayout;

    private MeasurementUnitAdapter measurementUnitAdapter;

    public final static int EDIT_FOOD_UNIT_REQUEST_CODE = 1100;

    private int pageIndex = 0;

    public static MeasurementUnitFragment newInstance() {
        MeasurementUnitFragment fragment = new MeasurementUnitFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerMeasurementUnitComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_measurement_unit, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar();
        loadInfo("");
        // 重新加载逻辑
        loadService = LoadSir.getDefault().register(smartRefreshLayout, (Callback.OnReloadListener) v -> {
            pageIndex = 0;
            loadInfo("");
        });
        smartRefreshLayout.setOnRefreshListener(refreshLayout -> {
            pageIndex = 0;
            loadInfo("");
        });
        smartRefreshLayout.setOnLoadMoreListener(refreshLayout -> {
            pageIndex++;
            loadInfo("");
        });
    }

    private void loadInfo(String unitContent) {
        mPresenter.getMeasurementUnitList(unitContent, pageIndex);
    }

    private void initTopBar() {
        topbarMeasurementUnitList.setTitle("計量單位");
        topbarMeasurementUnitList.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

    @OnClick({R2.id.btn_measurement_unit_search, R2.id.btn_new_measurement_unit})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_new_measurement_unit) {
            //新增計量單位
            startForResult(NewFoodUnitFragment.newInstance(null), EDIT_FOOD_UNIT_REQUEST_CODE);
        } else if (viewId == R.id.btn_measurement_unit_search) {
            //搜索計量單位
            loadInfo(edMeasurementUnitSearch.getText() + "");
        }
    }

    @Override
    public void loadUnitList(List<MeasurementUnitBean.DataBean.Unit> list) {
        smartRefreshLayout.finishRefresh();
        smartRefreshLayout.finishLoadMore();
        if (list != null && list.size() > 0) {
            loadService.showSuccess();
            smartRefreshLayout.setEnableLoadMore(true);
        } else {
            smartRefreshLayout.setEnableLoadMore(false);
            loadService.showCallback(EmptyCallback.class);
            return;
        }
        if (measurementUnitAdapter == null) {
            measurementUnitAdapter = new MeasurementUnitAdapter(list);
            measurementUnitAdapter.setOnItemChildClickListener((adapter, view, position) -> {
                List<MeasurementUnitBean.DataBean.Unit> data = measurementUnitAdapter.getData();
                MeasurementUnitBean.DataBean.Unit unit = data.get(position);
                new AppDialog().showWaringDialog(mContext, "是否確認刪除？", (view1, dialog) -> {
                    dialog.dismiss();
                    mPresenter.deleteMeasurementUnit(unit, position);
                });
            });
            measurementUnitAdapter.setOnItemClickListener((adapter, view, position) -> {
                List<MeasurementUnitBean.DataBean.Unit> data = measurementUnitAdapter.getData();
                MeasurementUnitBean.DataBean.Unit unit = data.get(position);
                startForResult(NewFoodUnitFragment.newInstance(unit), EDIT_FOOD_UNIT_REQUEST_CODE);
            });
            rvMeasurementUnitList.setAdapter(measurementUnitAdapter);
        } else {
            measurementUnitAdapter.setList(list);
        }
    }

    @Override
    public void deleteSuccess(int position) {
        measurementUnitAdapter.removeAt(position);
        if (measurementUnitAdapter.getData().size() == 0) {
            loadService.showCallback(EmptyCallback.class);
        }
    }

    @Override
    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        loadInfo("");
    }
}
