package com.gingersoft.gsa.cloud.table.mvp.contract;


import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.pay.PayMethod;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;

/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface OrderPayContract {
    interface View extends BaseOrderContract.View {

        void showTipDialog(String msg, String btnCancelInfo, String btnOkInfo);

        void showStatusDialog(int operatType);

        void paySuccess();

        void loadPayMethodsSuccess(List<PayMethod> payMethods);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseOrderContract.Model {

        Observable<BaseResult> getPayMethods(int brandId,int restaurantId,int payType);

        Observable<BaseResult> updateOrderPay(RequestBody requestBody);

//        Observable<Object> getN5SaleTxnId(String url);
//
//        Observable<BaseResult> updateOrderStatus( RequestBody formBody);
    }
}
