package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 15:41
 * Use: 採購食材頁面二級分類
 */
public class SecondCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectIndex = 0;
    private int checkedBg;
    private int unCheckedBg;

    private int checkedTextColor;
    private int unCheckedTextColor;

    public SecondCategoryAdapter(Context context, @Nullable List<OrderCategoryBean.FoodCategoryTrees> data) {
        super(R.layout.item_purchase_second_category, data);
        checkedBg = R.drawable.shape_theme_twelve_corners_bg;
        unCheckedBg = R.drawable.shape_white_twelve_corners_bg;
        checkedTextColor = ContextCompat.getColor(context, R.color.white);
        unCheckedTextColor = ContextCompat.getColor(context, R.color.color_3c);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees categoryBean) {
        viewHolder.setText(R.id.tv_second_category_title, categoryBean.getName());
        TextView tvName = viewHolder.getView(R.id.tv_second_category_title);
        CardView cardView = viewHolder.getView(R.id.card_purchase_category);
        viewHolder.setVisible(R.id.tv_second_category_title, TextUtil.isNotEmptyOrNullOrUndefined(categoryBean.getName()));
        if (viewHolder.getAdapterPosition() == selectIndex) {
            cardView.setBackground(ContextCompat.getDrawable(getContext(), checkedBg));
            tvName.setTextColor(checkedTextColor);
        } else {
            cardView.setBackground(ContextCompat.getDrawable(getContext(), unCheckedBg));
            tvName.setTextColor(unCheckedTextColor);
        }
    }

    public SecondCategoryAdapter setCheckedBg(int checkedBg) {
        this.checkedBg = checkedBg;
        return this;
    }

    public SecondCategoryAdapter setUnCheckedBg(int unCheckedBg) {
        this.unCheckedBg = unCheckedBg;
        return this;
    }

    public SecondCategoryAdapter setSelectIndex(int selectIndex) {
        int lastIndex = this.selectIndex;
        this.selectIndex = selectIndex;
        if (lastIndex >= 0 && lastIndex < getItemCount()) {
            notifyItemChanged(lastIndex);
        }
        if (this.selectIndex >= 0 && this.selectIndex < getItemCount()) {
            notifyItemChanged(this.selectIndex);
        }
        return this;
    }

    public SecondCategoryAdapter setCheckedTextColor(int checkedTextColor) {
        this.checkedTextColor = checkedTextColor;
        return this;
    }

    public SecondCategoryAdapter setUnCheckedTextColor(int unCheckedTextColor) {
        this.unCheckedTextColor = unCheckedTextColor;
        return this;
    }

    public int getSelectIndex() {
        return selectIndex;
    }

}
