package com.gingersoft.gsa.cloud.table.mvp.action.order;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.pay.bean.PosActionStatusExceptionParam;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.PosPay;
import com.gingersoft.gsa.cloud.pay.pos.fragment.PosActionStatusExceptionFragment;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.VoidRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.VoidRespose;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.base.delegate.IActivity;
import com.jess.arms.mvp.IView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

/**
 * @作者: bin
 * @創建時間: 2021-01-15 15:19
 * @更新時間: 2021-01-15 15:19
 * @描述:取消订单
 */
public class CancelOrder implements Strategy<OrderManagerResponse> {

    private final String TAG = "CancelOrder";

    private BaseFragmentActivity mActivity;
    private IView mRootView;

    public CancelOrder(BaseFragmentActivity fragmentActivity, IView rootView) {
        this.mActivity = fragmentActivity;
        this.mRootView = rootView;
    }

    @Override
    public void action(OrderManagerResponse orderItem) {
        showCancelDialog(orderItem);
    }

    @Override
    public void destroy() {
        mActivity = null;
        mRootView = null;
    }

    private void showCancelDialog(OrderManagerResponse datasBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mActivity);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否取消訂單?");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (datasBean.withHywebPay() && AppDevices.isHywebPos()) {
                hywebOrderCancle(datasBean);
            } else {
                if (cancelListener != null) {
                    cancelListener.cancel(datasBean.getId());
                }
            }
        });
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    private void hywebOrderCancle(OrderManagerResponse datasBean) {
        GetTxnIdRequest txnIdRequest = new GetTxnIdRequest();
        txnIdRequest.setOrderId(datasBean.getId());
        if (!TextUtils.isEmpty(datasBean.getTableNumber())) {
            txnIdRequest.setTableExtId(datasBean.getTableId());
        } else {
            txnIdRequest.setTableId(datasBean.getTableId());
        }
        txnIdRequest.setAmount(datasBean.getAmount());
        VoidRequest voidRequest = new VoidRequest();
        PosPay.voidO(mActivity, mRootView, voidRequest, txnIdRequest, new OnPosActionListener<VoidRespose>() {

            @Override
            public void onPosSuccess(VoidRespose response) {
                LoganManager.w_order(TAG, "onPosSuccess: " + response.toString());
                if (cancelListener != null) {
                    cancelListener.refeshOrders();
                }
            }

            @Override
            public void onPosException(Exception e) {
                LoganManager.w_order(TAG, "onPosException： " + e.getMessage());
                PosActionStatusExceptionFragment statusExceptionFragment = (PosActionStatusExceptionFragment) mActivity.findFragment(PosActionStatusExceptionFragment.class);
                if (statusExceptionFragment == null) {
                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
                    statusExceptionParam.setAmount(datasBean.getAmount());
                    statusExceptionParam.setOrderId(datasBean.getId());
                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
                    statusExceptionParam.setPayMethodName("VISA測試");
                    statusExceptionParam.setPosAction(PosAction.VOID);
                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
                }else{
                    mActivity.start(statusExceptionFragment);
                }
            }

            @Override
            public void onPosInvalid(String e) {
                LoganManager.w_order(TAG, "onPosInvalid: " + e);
            }

            @Override
            public void onUpdateStatusSuccess(VoidRespose response) {
                LoganManager.w_order(TAG, "onUpdateStatusSuccess: " + response.toString());
            }

            @Override
            public void onUpdateStatusError(Throwable e) {
                LoganManager.w_order(TAG, "onUpdateStatusError： " + e.getMessage());
                if (mActivity.findFragment(PosActionStatusExceptionFragment.class) == null) {
                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
                    statusExceptionParam.setAmount(datasBean.getAmount());
                    statusExceptionParam.setOrderId(datasBean.getId());
                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
                    statusExceptionParam.setPayMethodName("VISA測試");
                    statusExceptionParam.setPosAction(PosAction.VOID);
                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
                }
            }
        });
    }

    private OnCancelListener cancelListener;

    public void setCancelListener(OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public interface OnCancelListener {
        void cancel(long orderId);

        void refeshOrders();
    }
}
