package com.gingersoft.gsa.other_order_mode.data.network

import com.gingersoft.gsa.other_order_mode.data.network.api.WeatherService
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlin.coroutines.suspendCoroutine

class CoolWeatherNetwork {

    private val orderService = ServiceCreator.create(WeatherService::class.java)

    private val service = ServiceCreator.create2(WeatherService::class.java)

    private val gsposService = ServiceCreator.create3(WeatherService::class.java)
    //獲取訂單列表
    suspend fun fetchOrderList(requestBody: RequestBody) = orderService.getOrderList(requestBody).await()

    //修改餐廳營業狀態
    suspend fun updateRestOpenStatus(requestBody: RequestBody) = service.updateRestOpenStatus(requestBody).await()

    //獲取訂單分組數量，例：待確認訂單數量，製作中訂單數量。。。
    suspend fun getOrderGroupNum(requestBody: RequestBody) = orderService.getOrderGroupNum(requestBody).await()

    //獲取訂單信息
    suspend fun getOrderInfo(requestBody: RequestBody) = orderService.getOrderDesc(requestBody).await()

    //獲取第三方物流信息
    suspend fun getShipanyOrderTime(requestBody: RequestBody) = gsposService.getShipanyOrderTime(requestBody).await()

    //修改訂單狀態
    suspend fun updateOrderStatus(requestBody: RequestBody) = orderService.updateOrderStatus(requestBody).await()

    //gspost修改訂單狀態
    suspend fun gsUpdateOrderStatus(requestBody: RequestBody) = service.gsUpdateOrderStatus(requestBody).await()

    //第三方配送接口
    suspend fun thirdDelivery(requestBody: RequestBody) = gsposService.thirdDelivery(requestBody).await()

    //修改自取訂單狀態
    suspend fun updateSelfOrderStatus(requestBody: RequestBody) = orderService.updateSelfOrderStatus(requestBody).await()

    // 獲取餐廳配送人員信息
    suspend fun getDeliveryInfo(requestBody: RequestBody) = orderService.getDeliveryInfo(requestBody).await()

    //獲取物流配置
    suspend fun getDeliveryConfigDTO(requestBody: RequestBody) = gsposService.getDeliveryConfigDTO(requestBody).await()

    //獲取歷史訂單
    suspend fun getHistoryOrderList(requestBody: RequestBody) = orderService.getHistoryOrderList(requestBody).await()

    //取消物流
    suspend fun cancelLogistics(requestBody: RequestBody) = gsposService.cancelLogistics(requestBody).await()

    //取消訂單，有物流需要提示先取消物流
    suspend fun cancelOrder(requestBody: RequestBody) = service.cancelOrder(requestBody).await()

    //獲取商家配置的取消訂單的原因
    suspend fun getCancelReason(requestBody: RequestBody) = service.getCancelReason(requestBody).await()

    //獲取商家配置的支付方式
    suspend fun getPayMethod(requestBody: RequestBody) = service.getPayMethod(requestBody).await()


    private suspend fun <T> Call<T>.await(): T {
        return suspendCoroutine { continuation ->
            enqueue(object : Callback<T> {
                override fun onFailure(call: Call<T>, t: Throwable) {
                    t.printStackTrace()
                    continuation.resumeWithException(t)
                }

                override fun onResponse(call: Call<T>, response: Response<T>) {
                    val body = response.body()
                    if (body != null) {
                        continuation.resume(body)
                    } else continuation.resumeWithException(RuntimeException("response body is null") as Throwable)
                }
            })
        }
    }

    companion object {

        private var network: CoolWeatherNetwork? = null

        fun getInstance(): CoolWeatherNetwork {
            if (network == null) {
                synchronized(CoolWeatherNetwork::class.java) {
                    if (network == null) {
                        network = CoolWeatherNetwork()
                    }
                }
            }
            return network!!
        }

    }

}