package com.gingersoft.gsa.other_order_mode.ui.adapter

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.HistoryOrderBean.DataBean
import com.gingersoft.gsa.other_order_mode.data.model.bean.OrderList
import com.gingersoft.gsa.other_order_mode.databinding.LayoutHistoryOrderItemBinding
import com.scwang.smartrefresh.layout.util.SmartUtil

class HistoryOrderAdapter(var stauts: String?, private val context: Context, var data: List<DataBean>?) : RecyclerView.Adapter<HistoryOrderAdapter.ViewHolder>() {
    //item點擊事件
    private var listenter: ((item: DataBean) -> Unit)? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_history_order_item, parent, false))
    }

    override fun getItemCount(): Int {
        return if (data == null) {
            0
        } else {
            data!!.size
        }
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = data?.get(position)
        holder.binding.data = data
        //堂食外賣背景
        val orderingMethodBg = GradientDrawable()
        orderingMethodBg.shape = GradientDrawable.OVAL
        holder.binding.orderingMethod =
                when {
                    data!!.order_type == 2 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state2_color))
                        "外"
                    }
                    data.order_type == 7 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state3_color))
                        "自"
                    }
                    else -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state1_color))
                        "堂"
                    }
                }
        holder.binding.orderingMethodBg = orderingMethodBg

        //支付方式背景 data.orderPayType==1?@color/table_send:@color/table_use
        //data.orderPayType==1?@string/cash_on_delivery:@string/online_payments
        val payMethodBg = GradientDrawable()
        payMethodBg.cornerRadius = SmartUtil.dp2px(10f).toFloat()
        holder.binding.payMethod =
                when {
                    data.orderPayType == 1 -> {
                        payMethodBg.setColor(getColor(R.color.cash_on_delivery_bg))
                        "貨到付款"
                    }
                    else -> {
                        payMethodBg.setColor(getColor(R.color.online_payments_bg))
                        "在線支付"
                    }
                }
        holder.binding.payMethodBg = payMethodBg

        holder.itemView.setOnClickListener {
            listenter?.invoke(data)
        }

        if (stauts != null) {
            if (stauts.equals("4")) {
                //已完成訂單
                holder.iv_end.setImageResource(R.drawable.ic_has_end)
            } else if (stauts.equals("6")) {
                //已取消訂單
                holder.iv_end.setImageResource(R.drawable.img_cancelled)
            }
        } else {
            holder.iv_end.setImageResource(R.drawable.ic_has_end)
        }
    }

    private fun getColor(color: Int): Int {
        return context.resources.getColor(color)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutHistoryOrderItemBinding = DataBindingUtil.bind(itemView)!!
        var iv_end = itemView.findViewById<ImageView>(R.id.iv_end)
    }

    fun setOnItemClickListenter(listenter: (item: DataBean) -> Unit) {
        this.listenter = listenter
    }
}