package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.ThirdViewUtil;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/17
 * 修订历史：2018/8/17
 * 描述：输入数字Dialog
 */

public class ChooseNumberDialog {

    private Context mContext;
    private Dialog dialog;

    @BindView(R2.id.ll_container)
    LinearLayout ll_container;

//    @BindView(R2.id.rl_head)
//    RelativeLayout rl_head;
//    @BindView(R2.id.ib_back_page)
//    ImageButton ib_back_page;
//    @BindView(R2.id.tv_title)
//    TextView tv_title;

    @BindView(R2.id.ed_value)
    EditText ed_value;
    @BindView(R2.id.btn_0)
    Button btn_0;
    @BindView(R2.id.btn_1)
    Button btn_1;
    @BindView(R2.id.btn_2)
    Button btn_2;
    @BindView(R2.id.btn_3)
    Button btn_3;
    @BindView(R2.id.btn_4)
    Button btn_4;
    @BindView(R2.id.btn_5)
    Button btn_5;
    @BindView(R2.id.btn_6)
    Button btn_6;
    @BindView(R2.id.btn_7)
    Button btn_7;
    @BindView(R2.id.btn_8)
    Button btn_8;
    @BindView(R2.id.btn_9)
    Button btn_9;
    @BindView(R2.id.btn_back)
    Button btn_back;
    @BindView(R2.id.btn_ten_plus)
    Button btn_ten_plus;

    //没有输入点击确认的提示
    private String emptyInputTip;
    //1、選擇人數、2、選擇食品數量
    private int type = 1;
    //选中10+的次数
    private int currentTenPlus = 0;

    public ChooseNumberDialog(Context context) {
        this.mContext = context;

        initView();
    }

    private void initView() {
        // 获取Dialog布局
        View view = LayoutInflater.from(mContext).inflate(R.layout.ui_dialog_input_number, null);

        ThirdViewUtil.bindTarget(this, view);//绑定

        // 定义Dialog布局和参数
        dialog = new Dialog(mContext, R.style.QMUI_Dialog);
        dialog.setContentView(view);
        dialog.setCancelable(false);

        // 调整dialog背景大小
        ll_container.setLayoutParams(
                new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.92), ViewGroup.LayoutParams.WRAP_CONTENT));

    }

    public ChooseNumberDialog builder() {
        initLanguage();
        return this;
    }

    private void initLanguage() {
        btn_back.setText("返回");
        ed_value.setHint("請按鍵錄入數量");
    }

    public void setValueHint(String hint) {
        ed_value.setHint(hint);
    }

    @OnClick({R2.id.btn_0, R2.id.btn_1, R2.id.btn_2, R2.id.btn_3, R2.id.btn_4, R2.id.btn_5, R2.id.btn_6, R2.id.btn_7, R2.id.btn_8, R2.id.btn_9, R2.id.btn_back, R2.id.btn_ten_plus})
    public void onClick(View v) {
        if (v.getId() == R.id.btn_0 || v.getId() == R.id.btn_1 || v.getId() == R.id.btn_2 ||
                v.getId() == R.id.btn_3 || v.getId() == R.id.btn_4 || v.getId() == R.id.btn_5 ||
                v.getId() == R.id.btn_6 || v.getId() == R.id.btn_7 || v.getId() == R.id.btn_8 ||
                v.getId() == R.id.btn_9) {
            inputNum(v);
        } else if (v.getId() == R.id.btn_back) {
            //返回
            if (onBackClickListener != null) {
                onBackClickListener.OnBackClick();
            }
            cancel();
        } else if (v.getId() == R.id.btn_ten_plus) {
            currentTenPlus++;
            ed_value.setText(currentTenPlus + "_");
        }
    }

    private void inputNum(View v) {
        int i = Integer.parseInt(v.getTag().toString());
        String values = String.valueOf(i);
        if (currentTenPlus > 0) {
            //有选择十整位
            values = (currentTenPlus * 10) + "_" + values;
        }
        if (values.length() > 0 && Integer.parseInt(split_value(values)) > 99) {
            //最大选择数99
            values = "99";
            ed_value.setText(values);
        } else {
            ed_value.setText(values);
        }
        if (!TextUtils.isEmpty(getInputNumber())) {
            if (onClickListener != null) {
                onClickListener.onComfirmClick(getInputNumber());
                clearValueText();
            }
            cancel();
        }
    }

    public void clearValueText() {
        currentTenPlus = 0;
        ed_value.setText("");
    }


    public String getInputNumber() {
        return split_value(ed_value.getText().toString().trim());
    }

    private String split_value(String value) {
        if (value.contains("_")) {
            String[] values = value.split("_");
            int tenBit = Integer.parseInt(values[0]);
            value = (tenBit + Integer.parseInt(values[1])) + "";
        }
        return value;
    }

    public void setBackBtnText(String text){
        btn_back.setText(text);
    }

    public String getEmptyInputTip() {
        return emptyInputTip;
    }

    public void setEmptyInputTip(String emptyInputTip) {
        this.emptyInputTip = emptyInputTip;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }


//    public void setTitle(String title) {
//        tv_title.setText(title);
//    }
//
//    public void setHeadLayoutVisibility(int visibility) {
//        rl_head.setVisibility(visibility);
//    }
//
//    public void setBackPageBtnVisibility(int visibility) {
//        ib_back_page.setVisibility(visibility);
//    }

    public ChooseNumberDialog setCancelable(boolean cancelable) {
        dialog.setCancelable(cancelable);
        return this;
    }

    public void show() {
        dialog.show();
    }

    public void cancel() {
        dialog.cancel();
    }


    private OnBackClickListener onBackClickListener;
    private OnClickListener onClickListener;

    public void setOnBackClickListener(OnBackClickListener clickListener) {
        onBackClickListener = clickListener;
    }

    public void setOnClickListener(OnClickListener clickListener) {
        onClickListener = clickListener;
    }

    public interface OnBackClickListener {
        void OnBackClick();
    }

    public interface OnClickListener {

        void onComfirmClick(String number);

        void onBackPage();
    }
}
