package com.gingersoft.gsa.other_order_mode.data.network

import com.gingersoft.gsa.cloud.constans.HttpsConstans
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.intercept.LoggingInterceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.util.concurrent.TimeUnit

object ServiceCreator {

    private val httpClient = OkHttpClient.Builder().connectTimeout(15, TimeUnit.SECONDS).addInterceptor(LoggingInterceptor())

    var ROOT_URL: String = HttpsConstans.ROOT_URL

    private var BASE_URL = "$ROOT_URL/ricepon-wechat/api/"
    private var BASE_URL2 = "$ROOT_URL/member-web/api/"
    private var BASE_URL3 = "$ROOT_URL/member-web/ricepon-gsa/api/"

    private val builder = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder2 = Retrofit.Builder()
            .baseUrl(BASE_URL2)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder3 = Retrofit.Builder()
            .baseUrl(BASE_URL3)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    fun <T> create(serviceClass: Class<T>): T = builder.build().create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = builder2.build().create(serviceClass)

    fun <T> create3(serviceClass: Class<T>): T = builder3.build().create(serviceClass)
}