package com.gingersoft.gsa.other_order_mode.model.viewModel

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog
import kotlinx.coroutines.launch

open class BaseViewModel : ViewModel() {

    protected fun showLoading(context: Context, message: String? = null) {
        if (message != null)
            LoadingDialog.showDialogForLoading(context, message, true)
        else
            LoadingDialog.showDialogForLoading(context)
    }

    protected fun cancelDialogForLoading() {
        LoadingDialog.cancelDialogForLoading()
    }

    protected fun launch(block: suspend () -> Unit, error: suspend (Throwable) -> Unit) = viewModelScope.launch {
        try {
            block()
        } catch (e: Throwable) {
            error(e)
        }
    }

}