package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseRespose;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderContentContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableDetail;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.TableService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderContentModel extends BaseModel implements OrderContentContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderContentModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseRespose> loadOrder(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .loadOrder(orderId);
    }

    @Override
    public Observable<BaseResult> createOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody);
    }

    @Override
    public Observable<BaseResult> addFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .addFood(requestBody);
    }

    @Override
    public Observable<BaseRespose> printOrder(RequestBody request) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .printOrder(request);
    }

    @Override
    public Observable<TableBean> getTables(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTables(restaurantId);
    }

    @Override
    public Observable<TableDetail> getTable(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTable(tableId);
    }

    @Override
    public Observable<BaseRespose> transferFood(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .transferFood(requestBody)
                .flatMap(new Function<BaseRespose, Observable<BaseRespose>>() {
                    @Override
                    public Observable<BaseRespose> apply(BaseRespose info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrder(MyOrderManage.getInstance().getOrderId());
                        }
                        return null;
                    }
                });
        return ob;
    }

    @Override
    public Observable<BaseResult> toOrderPay(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(formBody);
    }

    @Override
    public Observable<BaseResult> updateOrder(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrder(formBody);
    }

    @Override
    public Observable<BaseRespose> calculationPrice(long orderId) {
        return null;
    }
}