package com.gingersoft.gsa.delivery_pick_mode.ui.fragment

import android.os.Bundle
import androidx.lifecycle.Observer

import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.model.viewModel.HistoryOrderViewModel
import com.gingersoft.gsa.delivery_pick_mode.ui.adapter.HistoryOrderAdapter
import com.gingersoft.gsa.delivery_pick_mode.ui.base.BaseFragment
import com.gingersoft.gsa.delivery_pick_mode.util.InjectorUtil
import com.gingersoft.gsa.delivery_pick_mode.util.OtherOrderUtils
import com.gingersoft.gsa.delivery_pick_mode.util.setState
import kotlinx.android.synthetic.main.fragment_other_order.*

class HistoryFragment : BaseFragment(R.layout.fragment_other_order) {

    companion object {
        fun newInstance() = HistoryFragment()
    }

    private lateinit var viewModel: HistoryOrderViewModel
    private var mHistoryOrderAdapter: HistoryOrderAdapter? = null

    private var pageIndex = 1

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(activity!!.viewModelStore, InjectorUtil.getHistoryModelFactory())[HistoryOrderViewModel::class.java].apply {
            historyData.observe(viewLifecycleOwner, Observer{ it ->
                cancelDialogForLoading()
                refresh_layout.finishRefresh()
                refresh_layout.finishLoadMore()

                it?.let { _ ->
                    refresh_layout.setEnableLoadMore((it.data != null && it.data!!.size > 0))
                    if (mHistoryOrderAdapter == null) {
                        mHistoryOrderAdapter = it.data.let { it1 -> context?.let { it2 -> HistoryOrderAdapter(status.value, it2, it1) } }
                        rv_other_order.layoutManager = LinearLayoutManager(context)
                        rv_other_order.adapter = mHistoryOrderAdapter
                        mHistoryOrderAdapter!!.setOnItemClickListenter { it ->
                            showLoading()
                            viewModel.getOrderInfo(it.Id.toString()) { it2 ->
                                cancelDialogForLoading()
                                if (it2.data != null && it2.data!!.isNotEmpty()) {
                                    //顯示彈窗
                                    context?.let { context ->
                                        OtherOrderUtils.showOrderDetailsDialog(context, it2, it.STATUS, it.order_type, true) { _, _, _ ->
                                            //重印
                                            showLoading()
                                            viewModel.printOrder(context, it) {
                                                cancelDialogForLoading()
                                                if (it) {
                                                    ToastUtils.show(context, "打印成功")
                                                } else {
                                                    ToastUtils.show(context, "打印失敗")
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    ToastUtils.show(context, "未查詢到訂單信息")
                                }
                            }
                        }
                    } else {
                        mHistoryOrderAdapter!!.data = it.data
                        mHistoryOrderAdapter!!.stauts = status.value
                        mHistoryOrderAdapter!!.notifyDataSetChanged()
                    }
                }
                layout_nodata.setState(it?.data == null || it.data!!.size <= 0)
            })

            historyTime.observe(viewLifecycleOwner, Observer {
                //當時間發生變化，請求數據
                pageIndex = 1
                getHistoryInfo()
            })

            status.observe(viewLifecycleOwner, Observer {
                //用戶切換到已取消頁面或切換到已完成頁面
                pageIndex = 1
                getHistoryInfo()
            })

            searchValue.observe(viewLifecycleOwner, Observer {
                pageIndex = 1
                getHistoryInfo()
            })
        }
        refresh_layout.setPrimaryColorsId(R.color.color_f0, R.color.color_66)
        refresh_layout.setEnableRefresh(false)
        refresh_layout.setOnLoadMoreListener {
            pageIndex++
            getHistoryInfo()
        }
    }

    private fun getHistoryInfo(page: Int = pageIndex) {
        showLoading()
        viewModel.getHistoryOrderList(page.toString(), viewModel.searchValue.value!!, viewModel.historyTime.value!!, viewModel.historyTime.value!!, viewModel.status.value!!)
    }


}
