package com.joe.print.mvp.model.bean;

import android.content.Context;

import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.print.bean.PrjBean;
import com.joe.print.R;
import com.joe.print.mvp.print.utils.MyPrintUtils;

import java.util.ArrayList;
import java.util.List;

public class PrintInfoBean {

    //數組多長就有多少列
    private String[] content;
    //private int[] widght;//每列佔比權重

    private Boolean[] isBold = new Boolean[]{false};

    private Boolean[] isItalic = new Boolean[]{false};

    private Integer[] color = new Integer[]{0};

    //文字大小
    private Double[] size = new Double[]{1d};

    //語言，每列是什麼語言
    private String[] Language = new String[]{"tw"};
    //content數量為1時才生效，默認居中
    private int gravity = 1;

    public PrintInfoBean(String[] content) {
        this.content = content;
    }

    public PrintInfoBean(String[] content, String[] language) {
        this.content = content;
        Language = language;
    }

    public PrintInfoBean(String[] content, Double[] size) {
        this.content = content;
        this.size = size;
    }

    public PrintInfoBean(String[] content, Double[] size, String[] language) {
        this.content = content;
        this.size = size;
        Language = language;
    }


    public PrintInfoBean(String[] content, int gravity) {
        this.content = content;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold) {
        this.content = content;
        this.isBold = isBold;
    }

    public PrintInfoBean(String[] content, Double[] size, int gravity) {
        this.content = content;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Integer[] color, Double[] size, int gravity) {
        this.content = content;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Double[] size) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Double[] size, String[] language) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
        Language = language;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Integer[] color, Double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Boolean[] isItalic, Integer[] color, Double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public String[] getContent() {
        return content;
    }

    public void setContent(String[] content) {
        this.content = content;
    }

    public Boolean[] getIsBold() {
        return isBold;
    }

    public void setIsBold(Boolean[] isBold) {
        this.isBold = isBold;
    }

    public Boolean[] getIsItalic() {
        return isItalic;
    }

    public void setIsItalic(Boolean[] isItalic) {
        this.isItalic = isItalic;
    }

    public Integer[] getColor() {
        return color;
    }

    public void setColor(Integer[] color) {
        this.color = color;
    }

    public Double[] getSize() {
        return size;
    }

    public void setSize(Double[] size) {
        this.size = size;
    }

    public int getGravity() {
        return gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public String[] getLanguage() {
        return Language;
    }

    public void setLanguage(String[] language) {
        Language = language;
    }


    /**
     * 將prj數據轉為打印類
     *
     * @param datas             prj數據
     * @param printLocation     廚房位置
     * @param deviceBean        打印機信息
     * @return 打印類集合
     */
    public static List<List<PrintInfoBean>> transPrjBean(List<PrjBean.DataBean.Bean> datas, String printLocation, PrinterDeviceBean deviceBean) {
        List<List<PrintInfoBean>> prjPrintBeans = new ArrayList<>();
        //通過打印位置生成多張用於打印的bitmap
        List<PrjBean.DataBean.Bean> noCut = new ArrayList<>();
        for (PrjBean.DataBean.Bean prjbean : datas) {
            //遍歷當前打印位置所有的食品
            if (prjbean.getStatus() == 2) {
                //切紙，單獨生成一條prj數據
                List<PrjBean.DataBean.Bean> beans = new ArrayList<>();
                beans.add(prjbean);
                prjPrintBeans.add(getPrjPrintInfoBean(printLocation, beans, deviceBean));
            } else {
                //不切紙，保存到單獨的集合里，之後生成一組數據
                noCut.add(prjbean);
            }
        }
        if (noCut.size() > 0) {
            prjPrintBeans.add(getPrjPrintInfoBean(printLocation, noCut, deviceBean));
        }
        return prjPrintBeans;
    }

    private static boolean foodIsBold = false;//食品是否加粗
    private static boolean foodItemIsBold = false;//細項是否加粗
    private static boolean foodIsItalic = false;//食品是否斜體
    private static boolean modifierIsItalic = false;//細項是否斜體
    private static boolean numberIsFlip = false;//數量大於1顏色是否翻轉
    private static int foodFontSize = 1;//食品名字體大小
    private static int modifierFontSize = 1;//細項名字體大小
    private static int foodColor = 0;//食品顏色
    private static int modifierColor = 0;//細項顏色
    private static int paperWidth = 24;//紙張一行顯示多少字符，默認42
    private static double cnLength = 2;//中文字符占的寬度
    private static int foodNameWidth = 21;//食品名所佔寬度
    private static int foodNumWidth = 8;//食品數量佔的寬度
    private static int foodPriceWidth = 12;//食品價格佔的寬度

    /**
     * 生成一張prj打印數據
     *
     * @return
     */
    private static List<PrintInfoBean> getPrjPrintInfoBean(String key, List<PrjBean.DataBean.Bean> prjBeans, PrinterDeviceBean deviceBean) {
        List<PrintInfoBean> printInfoBeans = new ArrayList<>();
        initPrintConfig(deviceBean);
        if (prjBeans == null || prjBeans.size() <= 0) {
            return null;
        }
        PrjBean.DataBean.Bean prjBean = prjBeans.get(0);
        if (prjBean == null) {
            return null;
        }
        if (TextUtil.isEmptyOrNullOrUndefined(prjBean.getTableName())) {
            if (prjBean.getOrderType() == 7) {
                printInfoBeans.add(new PrintInfoBean(new String[]{"自取"}, new Boolean[]{true}, new Double[]{2d}, 0));
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getBillNo())) {
                    //訂單碼不為空
                    printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼:", prjBean.getBillNo()}, new Boolean[]{false, true}, new Double[]{1d, 2d}, 0));
                }
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getTakeFoodCode())) {
                    printInfoBeans.add(new PrintInfoBean(new String[]{"取餐碼:", prjBean.getTakeFoodCode()}, new Boolean[]{false, true}, new Double[]{1d, 2d}, 0));
                }
            } else {
                printInfoBeans.add(new PrintInfoBean(new String[]{"外賣"}, new Boolean[]{true}, new Double[]{2d}, 0));
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getBillNo())) {
                    //訂單碼不為空
                    printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼:", prjBean.getBillNo()}, new Boolean[]{false, true}, new Double[]{1d, 2d}, 0));
                } else if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getTakeFoodCode())) {
                    //取餐碼不為空
                    printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼:", prjBean.getTakeFoodCode()}, new Boolean[]{false, true}, new Double[]{1d, 2d}, 0));
                }
            }
        } else {
            printInfoBeans.add(new PrintInfoBean(new String[]{prjBean.getTableName()}, new Boolean[]{true}, new Double[]{2d}, 0));
        }
        //落單時間
        printInfoBeans.add(new PrintInfoBean(new String[]{"落單時間:" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_MDHM)}, new Double[]{1d}, 0));
        //廚房位置
        if (!TextUtil.isEmptyOrNullOrUndefined(key) && !key.equals("-1")) {
            printInfoBeans.add(new PrintInfoBean(new String[]{key + "廚房", " " + prjBean.getUserName()}, new Double[]{1d}, 0));
        }
        //人數
        if (prjBean.getPerson() != 0) {
            printInfoBeans.add(new PrintInfoBean(new String[]{"人數:" + prjBean.getPerson(), UserContext.newInstance().getMemberName()}, new Double[]{1d}, 0));
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1, paperWidth)}, 0));
        for (PrjBean.DataBean.Bean bean : prjBeans) {
            if (bean.getParentId() == 0) {
                //沒有父級id，則是第一級食品
                bean.setItemType(1);
            }
            //如果父級id不為0，是細項
            if (bean.getParentId() != 0) {
                bean.setItemType(2);//先設置為細項，再通過下面的遍歷確定是否是第三級細項
                //循環遍歷查找父級食品
                for (PrjBean.DataBean.Bean itembean : prjBeans) {
                    if (bean.getParentId() == itembean.getOrderDetailsId()) {
                        //如果父級是細項，則當前食品就是二級細項
                        bean.setItemType(bean.getItemType() + 1);
                        break;
                    }
                }
            }
            int beforeColor;
            if (bean.getItemType() == 1) {
                //如果是主食品
                beforeColor = foodColor;
            } else {
                //細項
                beforeColor = modifierColor;
            }
            if (bean.getNumber() > 1 && numberIsFlip) {
                //翻轉顏色
                if (beforeColor == 0) {
                    beforeColor = 2;
                } else {
                    beforeColor = 0;
                }
            }
            if (bean.getItemType() == 1) {
                //主食品
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", bean.getProductName()}, new Boolean[]{foodIsBold}, new Boolean[]{foodIsItalic}, new Integer[]{beforeColor}, new Double[]{2d}, 0));
            } else if (bean.getItemType() == 2) {
                //細項
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", " " + bean.getProductName()}, new Boolean[]{foodItemIsBold}, new Boolean[]{modifierIsItalic}, new Integer[]{beforeColor}, new Double[]{2d}, 0));
            } else if (bean.getItemType() == 3) {
                //二級細項
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", "  " + bean.getProductName()}, new Boolean[]{foodItemIsBold}, new Boolean[]{modifierIsItalic}, new Integer[]{beforeColor}, new Double[]{2d}, 0));
            }
        }
        PrintInfoBean printInfoBean = printInfoBeans.get(0);
        printInfoBean.setGravity(1);
        printInfoBeans.add(printInfoBean);
        return printInfoBeans;
    }

    /**
     * 生成外送印單
     *
     * @return
     */
    public static List<PrintInfoBean> getTakeAwayBillPrint(Context context, OrderDetails.DataBean data, PrinterDeviceBean deviceBean, PrintCurrencyBean printCurrencyBean) {
        List<PrintInfoBean> printInfoBeans = new ArrayList<>();
        initPrintConfig(deviceBean);
        if (data == null) {
            return null;
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{RestaurantInfoManager.newInstance().getBrandName()}, new Boolean[]{true}, new Double[]{2d}));
        printInfoBeans.add(new PrintInfoBean(new String[]{RestaurantInfoManager.newInstance().getRestaurantName()}, new Boolean[]{true}, new Double[]{2d}));

        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder(data.getOrder_type() == 2 ? "外送" : "自取", 2, paperWidth)}, new Boolean[]{true}, new Double[]{2d}));

        String payType = "";
        if (data.getOrderPayType() == 1) {
            payType = "貨到付款";
        } else if (data.getOrderPayType() == 0) {
            payType = "店內支付";
        } else if (data.getOrderPayType() == 2) {
//            payType = "在線支付:" + data.getPayName();
            payType = "在線支付";
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{payType}, new Boolean[]{true}, new Double[]{2d}));

        //送達時間或者取餐時間
        printInfoBeans.add(new PrintInfoBean(new String[]{data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime()}, new Boolean[]{true}, new Double[]{1d}));
        //加線
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 2, paperWidth)}, new Double[]{2d}));

        printInfoBeans.add(new PrintInfoBean(new String[]{"單號:" + data.getORDER_NO()}, new Double[]{1d}, 0));

        if (data.getOrder_type() == 7) {
            //自取  顯示 取餐碼
            if (!TextUtil.isEmptyOrNullOrUndefined(data.getTakeFoodCode())) {
                printInfoBeans.add(new PrintInfoBean(new String[]{"取餐碼:" + data.getTakeFoodCode()}, new Double[]{3d}, 0));
            }
        } else {
            //外送  顯示訂單碼
            printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼:" + data.getTakeFoodCode()}, new Double[]{3d}, 0));
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{"單號:" + data.getORDER_NO()}, new Double[]{1d}, 0));
        //開單時間
        printInfoBeans.add(new PrintInfoBean(new String[]{context.getString(R.string.create_order_time) + TimeUtils.parseTimeRepeat(data.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT)}, new Double[]{1d}, 0));
        //支付時間
        if (data.getOrderPayType() == 2) {
            if (data.getPayTime() != null) {
                printInfoBeans.add(new PrintInfoBean(new String[]{"支付時間:" + data.getPayTime()}, new Double[]{1d}, 0));
            }
        }
        //備註
        if (data.getRemark() != null && !data.getRemark().isEmpty()) {
            printInfoBeans.add(new PrintInfoBean(new String[]{"備註:" + data.getRemark()}, new Double[]{1d}, 0));
        }
        //下面開始打印食品
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("項目", 1, paperWidth)}, new Double[]{1d}));

        if (data.getPRODUCT_NAME() != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean productnameBean : data.getPRODUCT_NAME()) {
                //遍歷食品
                String foodName = productnameBean.getPRODUCT_NAME();
                String foodNum = "X" + productnameBean.getNum();
                String foodPrice = productnameBean.getPRICE();
                if (foodName != null) {
                    if (getChineseValueLength(foodName) > foodNameWidth) {
                        //如果食品名的長度大於設定的最大長度
                        printInfoBeans.add(new PrintInfoBean(new String[]{MyPrintUtils.getFormatText(foodName, foodNameWidth), getSpaceByTextLength(foodNum, foodNumWidth) + foodNum, getSpaceByTextLength(foodPrice, foodPriceWidth) + foodPrice}, new Double[]{1d}, 0));
                    } else {
                        printInfoBeans.add(new PrintInfoBean(new String[]{foodName + getSpaceByTextLength(foodName, foodNameWidth), getSpaceByTextLength(foodNum, foodNumWidth) + foodNum, getSpaceByTextLength(foodPrice, foodPriceWidth) + foodPrice}, new Double[]{1d}, 0));
                    }
                }
                if (productnameBean.getChild() != null) {
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : productnameBean.getChild()) {
                        //遍歷一級細項
                        String childFoodName = " -" + childBeanX.getPRODUCT_NAME();
                        String childFoodNum = "X" + childBeanX.getNum();
                        String childFoodPrice = childBeanX.getPRICE();
                        if (getChineseValueLength(childFoodName) > foodNameWidth) {
                            //如果食品名的長度大於設定的最大長度
                            printInfoBeans.add(new PrintInfoBean(new String[]{MyPrintUtils.getFormatText(childFoodName, foodNameWidth), getSpaceByTextLength(childFoodNum, foodNumWidth) + childFoodNum, getSpaceByTextLength(childFoodPrice, foodPriceWidth) + childFoodPrice}, new Double[]{1d}, 0));
                        } else {
                            printInfoBeans.add(new PrintInfoBean(new String[]{childFoodName + getSpaceByTextLength(childFoodName, foodNameWidth), getSpaceByTextLength(childFoodNum, foodNumWidth) + childFoodNum, getSpaceByTextLength(childFoodPrice, foodPriceWidth) + childFoodPrice}, new Double[]{1d}, 0));
                        }
                        if (childBeanX.getChild() != null) {
                            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                                //遍歷一級細項
                                String secondChildFoodName = "  -" + childBean.getPRODUCT_NAME();
                                String secondChildFoodNum = "X" + childBean.getNum();
                                String secondChildFoodPrice = childBean.getPRICE();
                                if (getChineseValueLength(secondChildFoodName) > foodNameWidth) {
                                    //如果食品名的長度大於設定的最大長度
                                    printInfoBeans.add(new PrintInfoBean(new String[]{MyPrintUtils.getFormatText(secondChildFoodName, foodNameWidth), getSpaceByTextLength(secondChildFoodNum, foodNumWidth) + secondChildFoodNum, getSpaceByTextLength(secondChildFoodPrice, foodPriceWidth) + secondChildFoodPrice}, new Double[]{1d}, 0));
                                } else {
                                    printInfoBeans.add(new PrintInfoBean(new String[]{secondChildFoodName + getSpaceByTextLength(secondChildFoodName, foodNameWidth), getSpaceByTextLength(secondChildFoodNum, foodNumWidth) + secondChildFoodNum, getSpaceByTextLength(secondChildFoodPrice, foodPriceWidth) + secondChildFoodPrice}, new Double[]{1d}, 0));
                                }
                            }
                        }
                    }
                }
//                for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : item.getChild()) {
//                    View secondView = getChild(childBeanX.getPRODUCT_NAME(), childBeanX.getNum(), childBeanX.getPRICE(), indentation);
//                    childLayout.addView(secondView);
//                    if (childBeanX.getChild() != null && childBeanX.getChild().size() > 0) {
//                        LinearLayout secondLayout = secondView.findViewById(R.id.layout_food_content);
//                        for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
//                            secondLayout.addView(getChild(childBean.getPRODUCT_NAME(), childBean.getNum(), childBean.getPRICE(), indentation * 2));
//                        }
//                    }
//                }
            }
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1, paperWidth)}, new Double[]{1d}));

        printInfoBeans.add(new PrintInfoBean(new String[]{getLeftRightText("合計啊啥的和發哈是打飛機:", "$" + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE()), paperWidth)}, new Boolean[]{false}, new Double[]{1d}));

        if (data.getLunchbox() != 0) {
            printInfoBeans.add(new PrintInfoBean(new String[]{getLeftRightText("餐盒費啊啥的和發哈是打飛機:", "$" + data.getLunchbox(), paperWidth)}, new Boolean[]{false}, new Double[]{1d}));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            printInfoBeans.add(new PrintInfoBean(new String[]{getLeftRightText("送貨費啊啥的和發哈是打飛機:", "$" + data.getDELIVERY_CHARGE(), paperWidth)}, new Boolean[]{false}, new Double[]{1d}));
        }
        double totalAmount = Double.parseDouble(data.getTOTAL_AMOUNT());
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                printInfoBeans.add(new PrintInfoBean(new String[]{getLeftRightText(coupon.getCouponName() + ":", "-$" + coupon.getDiscount_amount(), paperWidth)}, new Boolean[]{false}, new Double[]{1d}));
                totalAmount = MoneyUtil.sub(totalAmount, coupon.getDiscount_amount());
            }
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{getLeftRightText("總金額啊啥的和發哈是打飛機:", "$" + data.getTOTAL_AMOUNT(), paperWidth / 2)}, new Boolean[]{true}, new Double[]{2d}));

        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1, paperWidth)}, new Double[]{1d}));

        printInfoBeans.add(new PrintInfoBean(new String[]{"支付金額:", "$" + totalAmount}, new Boolean[]{true}, new Double[]{2d}, 0));

        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1, paperWidth)}, new Double[]{1d}));

        if (data.getOrder_type() == 2) {
            printInfoBeans.add(new PrintInfoBean(new String[]{context.getString(R.string.address) + data.getAddressDetail()}, 0));
            printInfoBeans.add(new PrintInfoBean(new String[]{"收貨人:" + data.getRECEIVER()}, 0));
        }
        //手機號
        printInfoBeans.add(new PrintInfoBean(new String[]{"手機號:" + data.getPHONE()}, 0));
        return printInfoBeans;
    }

    /**
     * 左右顯示文字
     *
     * @param leftText  左側內容
     * @param rightText 右側內容
     * @param maxLength 最大長度
     * @return
     */
    private static String getLeftRightText(String leftText, String rightText, int maxLength) {
        int leftMaxLength = maxLength / 2 - 2;
        int leftLength = (int) getChineseValueLength(leftText);
        StringBuilder stringBuilder = new StringBuilder();
        if (getChineseValueLength(leftText) > leftMaxLength) {
            //如果左側文本的長度大於設定的最大長度，換行
            List<String> stringList = getFormatList(leftText, maxLength);
            for (int i = 0; i < stringList.size(); i++) {
                stringBuilder.append(stringList.get(i));
                if (i == 0) {
                    stringBuilder.append(getSpaceByTextLength(rightText, leftMaxLength));
                    stringBuilder.append(rightText);
                }
            }
        } else {
            stringBuilder.append(leftText);
            stringBuilder.append(getSpaceByTextLength(rightText, maxLength - leftLength));
            stringBuilder.append(rightText);
        }
        return stringBuilder.toString();
    }


    /**
     * 獲取縮進，通過文字和最大長度
     *
     * @param text
     * @param MaxLength
     * @return
     */
    private static String getSpaceByTextLength(String text, int MaxLength) {
        int spaceLength = (int) Math.ceil(MaxLength - getChineseValueLength(text));
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < spaceLength; i++) {
            space.append(" ");
        }
        return space.toString();
    }

    /**
     * 初始化打印配置
     *
     * @param deviceBean        打印機
     */
    private static void initPrintConfig(PrinterDeviceBean deviceBean) {
        foodColor = deviceBean.getFoodComplexion();
        modifierColor = deviceBean.getModifierComplexion();
        foodIsBold = deviceBean.getFoodIsBold() == 1;
        foodItemIsBold = deviceBean.getModifierIsBold() == 1;
        foodIsItalic = deviceBean.getFoodIsItalic() == 1;
        modifierIsItalic = deviceBean.getModifierIsItalic() == 1;
        numberIsFlip = deviceBean.getNumberIsFlip() == 1;
        if ((deviceBean.getPrinterName() != null && deviceBean.getPrinterName().toLowerCase().contains("EPSON".toLowerCase()))
                && (deviceBean.getModel() != null && deviceBean.getModel().toLowerCase().contains("TM-U220B".toLowerCase()))) {
            cnLength = 1.5;
        } else {
            cnLength = 2;
        }
        if (deviceBean.getLineFontStop() > 0) {
            paperWidth = deviceBean.getLineFontStop();
        }
        foodNameWidth = (int) (paperWidth * 0.5);
        foodNumWidth = (int) (paperWidth * 0.2);
        foodPriceWidth = (int) (paperWidth * 0.3);
    }


    /**
     * 獲取一條直線
     *
     * @param text       直線中間需要顯示的文字
     * @param fontSize   字體大小
     * @param paperWidth 紙張寬度
     * @return
     */
    private static String getLineBorder(String text, double fontSize, int paperWidth) {
        if (fontSize == 0) {
            fontSize = 1;
        } else if (fontSize == 2) {
            fontSize = 1.5;
        }
        //中文字符個數，Epson打印機每個中文字符佔1.5格
        double cnCount = getChineseValueLength(text);
        int count = (int) Math.floor(((paperWidth / fontSize) - cnCount));
        if (count <= 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        builder.append(text);
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        return builder.toString();
    }

    private static String abc = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    /**
     * 如果超過紙張寬度的英文，換行時，要截取得當
     * 23
     *
     * @return
     */
    public static List<String> getFormatList(String content, int paperWidth) {
        List<String> stringList = new ArrayList<>();
        if (content.length() > paperWidth) {
            int lastIndex = 0;//上次截取時最後的下標
            while (true) {
                if (lastIndex + paperWidth >= content.length()) {
                    String footStr = content.substring(lastIndex);
                    stringList.add(footStr);
                    return stringList;
                } else {
                    String headerStr = content.substring(lastIndex, lastIndex + paperWidth);
                    String nextContext = content.substring(lastIndex + paperWidth, lastIndex + paperWidth + 1);
                    if (abc.contains(headerStr.charAt(headerStr.length() - 1) + "") && abc.contains(nextContext)) {
                        //如果最後一位是英文單詞，往前找找到空格或者不是英文的，然後換行
                        for (int j = headerStr.length() - 1; j >= 0; j--) {
                            String tchar = headerStr.charAt(j) + "";
                            if (j == 0) {
                                //循環完了都沒找到，就不管了
                                stringList.add(headerStr);
                                lastIndex += paperWidth;
                                break;
                            }
                            if (!abc.contains(tchar)) {
                                //找到不是英文的那個
                                String newHeaderStr = headerStr.substring(0, j + 1);
                                stringList.add(newHeaderStr);
                                lastIndex += j + 1;
                                break;
                            }
                        }
                    } else {
                        lastIndex += paperWidth;
                        stringList.add(headerStr);
                    }
                }
            }
        } else {
            return stringList;
        }
    }

    /**
     * 根據字符串獲取長度，中文長度為2，在那台針式打印機長度為1.5
     *
     * @param value
     * @return
     */
    private static double getChineseValueLength(String value) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += cnLength;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }

}
