package com.gingersoft.gsa.cloud.pay.pos;

import com.gingersoft.gsa.cloud.common.loadsir.pos.BasePosCallback;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;

/**
 * @作者: bin
 * @創建時間: 2020-12-29 20:15
 * @更新時間: 2020-12-29 20:15
 * @描述:POS事件回調
 */
public interface OnPosActionListener<T extends HywebPosResponse> {

    /**
     * N5回調成功
     * @param response
     */
     void onPosSuccess(T response);

    /**
     * N5回調狀態異常，需要去重試查詢
     * @param e
     */
    void onPosException(Exception e);

    /**
     * N5調起失敗
     * @param e
     */
    void onPosInvalid(String e);

    /**
     * 更新狀態成功
     * @param response
     */
     void onUpdateStatusSuccess(T response);

    /**
     * 更新狀態失敗
     * @param e
     */
    void onUpdateStatusError(Throwable e);
}
