package com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp;

import android.app.Activity;
import android.content.Context;

import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.PrintPaymentStubRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.jess.arms.mvp.IView;

/**
 * @作者: bin
 * @創建時間: 2021-01-12 14:47
 * @更新時間: 2021-01-12 14:47
 * @描述:
 */
public class PrintPaymentStubImpl extends IPosAction {

    private String mTxnId;

    public PrintPaymentStubImpl(Context context, IView iView, PosAction action, String txnId, OnPosActionListener onPosActionListener, boolean showLoading) {
        super(context, iView, action, showLoading);
        this.mTxnId = txnId;
        this.mOnPosActionListener = onPosActionListener;
    }

    @Override
    protected void onPosActionBefore() {
        //打印存根
        PrintPaymentStubRequest stub = new PrintPaymentStubRequest();
        stub.setTXN_ID(mTxnId);
        onPosToAction(GsonUtils.GsonString(stub));
    }

    @Override
    public void onPosSuccess(Context context, HywebPosResponse posResponse, Activity originalActivity) {
        super.onPosSuccess(context, posResponse, originalActivity);
        canCelLoadingDialog();
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosSuccess(posResponse);
        }
    }

    @Override
    public void onPosException(Exception e) {
        super.onPosException(e);
        canCelLoadingDialog();
        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosException(e);
        }
    }
}
