package service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;

import androidx.annotation.Nullable;
import util.UpdateAppReceiver;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/2/16
 * 修订历史：2019/2/16
 * 描述：
 */
public class UpdateAppService extends Service {

    private BroadcastReceiver receiver = new UpdateAppReceiver();


    @Override
    public void onCreate() {
        super.onCreate();

        // 动态注册receiver 适配8.0 receiver 静态注册没收不到广播
        IntentFilter intentFilter = new IntentFilter("teprinciple.update");
        registerReceiver(receiver, intentFilter);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        unregisterReceiver(receiver); // 注销广播
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

}
