package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.supply_chain.mvp.content.Constant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:41
 * Use:食材信息
 */
@Data
public class PurchaseFoodBean implements Serializable {
    private static final long serialVersionUID = 7084280906070243339L;
    public static final String CATEGORY_DIVIDER = "-";
    private Integer id;
    private String supplierName;
    private String images;
    private String foodNo;
    private String name;
    /**
     * 單價
     */
    private Double unitPrice;
    /**
     * 分類名
     */
    private String foodCategoryName;
    /**
     * 應該是分類的父級id
     */
    private int parentId;
    private String remarks;
    private int quantityStarts;
    private int quantityEnd;
    /**
     * 包裝描述：這個字段有值，顯示在採購列表，沒有值，採購列表顯示基本單位
     */
    private String packingDescription;
    private long createTime;
    private int foodQuantity;
    /**
     * 最低採購金額，食品列表用
     */
    private double minimumAmount;
    /**
     * 基本單位類型
     */
    private String basicUnitName;
    /**
     * 採購商地址
     */
    private String address;
    /**
     * 分類id
     */
    private Integer foodCategoryId;

    /**
     * 所屬供應商id
     */
    private Integer supplierId;
    /**
     * 是否選中
     */
    private boolean isChecked = true;
    /**
     * 是否刪除
     * {@link Constant.DELETE,Constant.NORMAL}
     */
    private int deletes;
    private int restaurantId;
    private int brandId;
    private InventoryAlarm inventoryAlarm;

    /**
     * 預警的信息，獲取詳情接口返回的不是對象，傳遞給後台時需要轉為對象
     * 所以需要在這裡建這幾個字段，用於接收
     */
    private Integer inventoryWarningId;
    private boolean reviews;
    private int minimumInventory;
    private int shelfLife;
    private int warningDays;

    /**
     * 庫存預警 模塊
     */
    @Data
    public static class InventoryAlarm implements Serializable {
        private Integer id;
        /**
         * 是否審核  0否 1是
         */
        private int reviews;
        /**
         * 最低庫存
         */
        private int minimumInventory;
        /**
         * 保質期
         */
        private int shelfLife;
        /**
         * 保質期預警天數
         */
        private int warningDays;
    }

    /**
     * 副單位
     */
    private List<DeputyUnitBean> foodUnits;

    public boolean isChecked() {
        return isChecked;
    }

    public void setChecked(boolean checked) {
        isChecked = checked;
    }

    /**
     * 复制一個類
     * @param old
     * @return
     */
    public static Object copy(Object old) {
        Object clazz = null;
        try {
            // 写入字节流
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(old);
            // 读取字节流
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clazz = (Object) ois.readObject();
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return clazz;
    }
}
