package com.gingersoft.gsa.cloud.ui.view;

import android.content.Context;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;

import java.lang.reflect.Method;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/5
 * Time: 16:28
 * Use: 不會彈出軟鍵盤的輸入框
 */
public class NoSoftKeyboardEditText extends AppCompatEditText {
    public NoSoftKeyboardEditText(@NonNull Context context) {
        super(context);
        init();
    }

    public NoSoftKeyboardEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public NoSoftKeyboardEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    public void init() {
        Class<EditText> cls = EditText.class;
        Method method;
        try {
            method = cls.getMethod("setShowSoftInputOnFocus", boolean.class);
            method.setAccessible(true);
            method.invoke(this, false);
        } catch (Exception e) {
            e.printStackTrace();
        }
        addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                setSelection(s.length());
            }
        });
    }
}
