package com.gingersoft.coldchain_module.mvp.model.service;

import com.gingersoft.coldchain_module.mvp.model.bean.CancelLogisticsBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ReadBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;

public interface OrderDetailService {

    @Headers({"Domain-Name: ricepon_wechat"})
    @POST("wechat/findOrderDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<OrderDetails> findOrderDetails(@Body RequestBody requestBody);

    @Headers({"Domain-Name: member-web"})
    @POST("order/updateOrderInfoIsRead" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<ReadBean> setIsRead(@Body RequestBody requestBody);

    @Headers({"Domain-Name: member_web_ricepon_gsa"})
    @POST("gsa/shipAnyOrdersNew" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<ShipAnyOrdersNewBean> thirdDelivery(@Body RequestBody requestBody);

//    @Headers({"Domain-Name: member-web"})
//    @POST("order/updateOrderStatus" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
//    Observable<UpdateOrderStatusBean> cancelOrder(@Body RequestBody requestBody);

    @Headers({"Domain-Name: member-web"})
    @POST("order/updateOrderStatus" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<UpdateOrderStatusBean> gsUpdateOrderStatus(@Body RequestBody requestBody);


    @Headers({"Domain-Name: member_web_ricepon_gsa"})
    @POST("gsa/cancelOrder" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<CancelLogisticsBean> cancelLogistics(@Body RequestBody requestBody);

    @POST("printerRecording/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> addPrj(@Body RequestBody requestBody);

}
