package com.gingersoft.gsa.cloud.table.mvp.model.table;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.common.bean.table.TableBean;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯功能策略類，所有餐檯功能都需要繼承這個
 */
public abstract class TableActionStrategy {

    protected Context mContext;

    public TableActionStrategy(Context context) {
        this.mContext = context;
    }

    public abstract void action(TableBean.DataBean dataBean);

    protected void splitTableAction(){
        if (actionListener != null) {
            actionListener.splitTableAction();
        }
    }

    protected void cancel() {
        if (actionListener != null) {
            actionListener.cancel();
        }
    }

    private OnActionListener actionListener;

    public void setActionListener(OnActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public interface OnActionListener {
        void splitTableAction();
        void cancel();
    }
}
