package com.gingersoft.gsa.cloud.base.adapter.print;

import android.graphics.Typeface;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 */
public class FoodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    private int foodFontSize = 24;
    private int modifierFontSize = 24;
    private int foodIsBold = 2;
    private int modifierIsBold = 2;
    private int foodIsItalic = 2;
    private int modifierIsItalic = 2;
    private int numberIsFlip = 2;//熱敏打印沒有顏色，翻轉用不了

    private boolean showPrice = true;

    public FoodAdapter(@Nullable List<OrderDetail> data, PrinterDeviceBean deviceBean, boolean showPrice) {
        super(R.layout.print_item_food, data);
        try {
            this.foodFontSize = Integer.parseInt(deviceBean.getFoodFont()) * 2;
            this.modifierFontSize = Integer.parseInt(deviceBean.getModifierFont()) * 2;
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.foodIsBold = deviceBean.getFoodIsBold();
        this.modifierIsBold = deviceBean.getModifierIsBold();
        this.foodIsItalic = deviceBean.getFoodIsItalic();
        this.modifierIsItalic = deviceBean.getModifierIsItalic();
        this.numberIsFlip = deviceBean.getNumberIsFlip();
        this.showPrice = showPrice;
    }

    /**
     * @param data
     * @param deviceBean 打印機信息
     */
    public FoodAdapter(@Nullable List<OrderDetail> data, PrinterDeviceBean deviceBean) {
        super(R.layout.print_item_food, data);
        try {
            this.foodFontSize = Integer.parseInt(deviceBean.getFoodFont()) * 2;
            this.modifierFontSize = Integer.parseInt(deviceBean.getModifierFont()) * 2;
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.foodIsBold = deviceBean.getFoodIsBold();
        this.modifierIsBold = deviceBean.getModifierIsBold();
        this.foodIsItalic = deviceBean.getFoodIsItalic();
        this.modifierIsItalic = deviceBean.getModifierIsItalic();
        this.numberIsFlip = deviceBean.getNumberIsFlip();
    }

    public FoodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.print_item_food, data);
    }


    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        TextView tvFoodName = helper.getView(R.id.tv_food_name);
        TextView tvNum = helper.getView(R.id.tv_food_quantity);
        TextView tvPrice = helper.getView(R.id.tv_food_price);
        if (showPrice) {
            tvPrice.setVisibility(View.VISIBLE);
        } else {
            tvPrice.setVisibility(View.GONE);
        }
        boolean isBold, isItalic;
        if (item.getItemType() == 2) {
            //細項，縮進
            helper.setText(R.id.tv_food_name, "\u3000" + item.getProductName());
            tvFoodName.setTextSize(modifierFontSize);
            tvNum.setTextSize(modifierFontSize);
            tvPrice.setTextSize(modifierFontSize);

            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else if (item.getItemType() == 3) {
            //細項，縮進
            helper.setText(R.id.tv_food_name, "\u3000\u3000" + item.getProductName());
            tvFoodName.setTextSize(modifierFontSize);
            tvNum.setTextSize(modifierFontSize);
            tvPrice.setTextSize(modifierFontSize);
            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else {
            helper.setText(R.id.tv_food_name, item.getProductName());
            tvFoodName.setTextSize(foodFontSize);
            tvNum.setTextSize(foodFontSize);
            tvPrice.setTextSize(foodFontSize);
            isBold = foodIsBold == 1;
            isItalic = foodIsItalic == 1;
        }

        if (isBold && isItalic) {
            tvFoodName.setTypeface(null, Typeface.BOLD_ITALIC);
            tvNum.setTypeface(null, Typeface.BOLD_ITALIC);
            tvPrice.setTypeface(null, Typeface.BOLD_ITALIC);
        } else if (isBold) {
            tvFoodName.setTypeface(null, Typeface.BOLD);
            tvNum.setTypeface(null, Typeface.BOLD);
            tvPrice.setTypeface(null, Typeface.BOLD);
        } else if (isItalic) {
            tvFoodName.setTypeface(null, Typeface.ITALIC);
            tvNum.setTypeface(null, Typeface.ITALIC);
            tvPrice.setTypeface(null, Typeface.ITALIC);
        } else {
            tvFoodName.setTypeface(null, Typeface.NORMAL);
            tvNum.setTypeface(null, Typeface.NORMAL);
            tvPrice.setTypeface(null, Typeface.NORMAL);
        }
//        tvFoodName.setTypeface(null, Typeface.BOLD_ITALIC);
//        tvFoodName.setTypeface(null, Typeface.BOLD);
//        tvFoodName.setTypeface(null, Typeface.ITALIC);
//        tvFoodName.setTypeface(null, Typeface.NORMAL);
        tvNum.setText("X" + item.getNumber());
        tvPrice.setText("$" + item.getPrice());
    }
}
