package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.DiscountDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodReason;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MemberService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealStandModel extends BaseModel implements MealStandContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public MealStandModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryAllFoodByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodGroupList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodGroupByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByQueryBuilder(parentId);
        return foods;
    }


    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return daoUtils.queryModifiersByFid(fid, mode);
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        List<ComboItem> foodCombo = comboItemDao.queryComboItemsByFidQueryBuilder(fid);
        return foodCombo;
    }

    @Override
    public List<FoodCombo> isComboFood(long fid) {
        FoodComboDaoUtils foodComboDaoUtils = new FoodComboDaoUtils(mApplication);
        return foodComboDaoUtils.queryCombosFoodsByQueryBuilder(fid);
    }

    @Override
    public List<FoodModifier> queryDB_FoodModifierList(long fid) {
        return null;
    }

    @Override
    public List<Discount> queryDB_DiscountList(String discountType) {
        DiscountDaoUtils discountDaoUtils = new DiscountDaoUtils(mApplication);
        return discountDaoUtils.queryDiscountByQueryBuilder();
    }

    @Override
    public Observable<BaseResult> getCurrentSoldoutFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getCurrentSoldoutFood(requestBody);
    }

    @Override
    public Observable<BaseOrderRespose> loadOrder(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .loadOrder(orderId);
    }

    @Override
    public Observable<BaseResult> createOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody);
    }

    @Override
    public Observable<BaseResult> addFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .addFood(requestBody);
    }

    @Override
    public Observable<BaseOrderRespose> deleteFood(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .deleteFood(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseOrderRespose>>() {
                    @Override
                    public Observable<BaseOrderRespose> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrder(MyOrderManage.getInstance().getOrderId());
                        }
                        return null;
                    }
                });
        return ob;
    }

    @Override
    public Observable<BaseOrderRespose> calculationPrice(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .calculationPrice(orderId);
    }

    @Override
    public Observable<BaseOrderRespose> printOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .printOrder(requestBody);
    }

    @Override
    public Observable<FoodReason> getRestaurantFoodReason(int brandId, int restaurantId, int type) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getRestaurantFoodReason(brandId, restaurantId, type);
    }

    @Override
    public Observable<BaseResult> queryMember(int type, String parm, String shopName, int tableId, String tableNumber) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .queryMember(type, parm, shopName, tableId, tableNumber);
    }

    @Override
    public Observable<BaseResult> memberUse(int tableId, String tableNumber, long memberId) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .memberUse(tableId, tableNumber, memberId);
    }

    @Override
    public Observable<BaseResult> memberUseCancel(int tableId, String tableNumber, long memberId) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .memberUseCancel(tableId, tableNumber, memberId);
    }

    @Override
    public Observable<BaseResult> toOrderPay(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(requestBody);
    }

    @Override
    public Observable<BaseResult> updateOrder(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrder(formBody);
    }
}