package com.gingersoft.gsa.other_order_mode.util

import android.app.Dialog
import android.content.Context
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.base.widget.DialogUtils
import com.gingersoft.gsa.cloud.print.bean.OrderDetails
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.databinding.LayoutOrderInfoDialogNewBinding
import com.gingersoft.gsa.other_order_mode.ui.adapter.FoodListAdapter
import com.jess.arms.utils.ArmsUtils

object OtherOrderUtils {

    fun showOrderDetailsDialog(context: Context, data: OrderDetails, orderStuats: Int, orderType: Int, isHistory: Boolean = false, listenter: ((view: View, data: OrderDetails.DataBean, dialog: Dialog) -> Unit)?) {
        object : DialogUtils(context, R.layout.layout_order_info_dialog_new) {
            override fun initLayout(hepler: ViewHepler, dialog: Dialog) {
                if (data.data != null) {
                    val tvStatus = hepler.getView<TextView>(R.id.tv_order_state)
                    val orderData = data.data!![0]
                    val layoutOrderInfoDialogBinding: LayoutOrderInfoDialogNewBinding = DataBindingUtil.bind(hepler.contentView)!!
                    layoutOrderInfoDialogBinding.data = orderData
                    layoutOrderInfoDialogBinding.isSelf = orderType == 7
                    layoutOrderInfoDialogBinding.totalAmount = orderData.TOTAL_AMOUNT!!.toDouble()
                    //是歷史訂單，就不顯示訂單狀態
                    layoutOrderInfoDialogBinding.isHistory = isHistory
                    var btnContent =""
                    var cancelBtnContent = ""

                    val type = if (orderType == 7) "自取" else "外送"
                    val orderStatus: String

                    when (orderStuats) {
                        2 -> {
                            if (orderType == 7) {
                                //自取
                                btnContent = "製作完成"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state0_color))
                                cancelBtnContent = "取消訂單"
                            } else {
                                if (orderData.isDelete == 0) {
                                    btnContent = "重印"
                                    cancelBtnContent = "取消物流"
                                } else {
                                    btnContent = "指派送貨"
                                    cancelBtnContent = "取消訂單"
                                }
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state1_color))
                            }
                            orderStatus = "製作中"
                        }
                        3 -> {
                            btnContent = "結賬"
                            if (orderType == 7) {
                                //自取
                                orderStatus = "待取餐"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state3_color))
                            } else {
                                if(orderData.isDelete == 0){
                                    //如果是第三方物流，不顯示結賬按鈕
                                    btnContent = "重印"
                                }
                                orderStatus = "派送中"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state2_color))
                            }
                        }
                        else -> {
                            btnContent = "確認訂單"
                            orderStatus = "待確認"
                            tvStatus.setTextColor(context.resources.getColor(R.color.order_state0_color))
                            cancelBtnContent = "取消訂單"
                        }
                    }
                    layoutOrderInfoDialogBinding.patMethod = when (orderData.payType) {
                        1 -> "積分支付"
                        2 -> "支付寶"
                        3 -> "财付通"
                        4 -> "微信支付"
                        5 -> "貨到付款"
                        6 -> "其他支付"
                        else -> ""
                    }

                    if (isHistory) {
                        cancelBtnContent = ""
                        btnContent = "重印"
                    }
                    layoutOrderInfoDialogBinding.orderStatus = type + orderStatus
                    layoutOrderInfoDialogBinding.btnContent = btnContent
                    layoutOrderInfoDialogBinding.cancelBtnContent = cancelBtnContent
                    layoutOrderInfoDialogBinding.estimatedTime = orderData.estimatedTime
                }

                val rvFood: RecyclerView = hepler.getView(R.id.rv_food)
                rvFood.layoutManager = LinearLayoutManager(context)
                rvFood.adapter = FoodListAdapter(context, data.data!![0].PRODUCT_NAME!!)
                hepler.setOnClickListenter(R.id.btn_assign_shipping) {
                    //指派送貨或是確認訂單？
                    //確認訂單，調用接口，並打印
                    listenter?.invoke(it, data.data!![0], dialog)
                }

                hepler.setOnClickListenter(R.id.btn_cancel_order) {
                    //取消訂單
                    listenter?.invoke(it, data.data!![0], dialog)
                }

                hepler.getView<ImageView>(R.id.iv_close).setOnClickListener {
                    dialog.dismiss()
                }
            }
        }.setWidth((ArmsUtils.getScreenWidth(context) * 0.9).toInt())
                .setHeight((ArmsUtils.getScreenHeidth(context) * 0.9).toInt())
                .show()

    }

}