package com.gingersoft.gsa.cloud.base.adapter.print;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;

import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 */
public class FoodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    public FoodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.print_item_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        if (item.getItemType() == 2) {
            //細項，縮進
            helper.setText(R.id.tv_food_name, "\u3000" + item.getProductName());
        } else if (item.getItemType() == 3) {
            //細項，縮進
            helper.setText(R.id.tv_food_name, "\u3000\u3000" + item.getProductName());
        } else {
            helper.setText(R.id.tv_food_name, item.getProductName());
        }
        helper.setText(R.id.tv_food_quantity, String.valueOf(item.getNumber()));
        helper.setText(R.id.tv_food_price, "$" + item.getPrice());
    }
}
