package com.gingersoft.gsa.cloud.base.adapter.print;

import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by Wyh on 2020/2/20.
 */
public class KitChenPrintFoodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    private int indentation = 0;

    public KitChenPrintFoodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.print_kitchen_item_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        TextView textView = helper.getView(R.id.tv_food_name);
        if (helper.getAdapterPosition() == 0) {
            //只第一次測量一下
            indentation = new BigDecimal(textView.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }
        int paddingLeft;
        if (item.getItemType() == 2) {
            //細項，縮進
            paddingLeft = indentation;
        } else if (item.getItemType() == 3) {
            //細項，縮進
            paddingLeft = indentation * 2;
        } else {
            paddingLeft = 0;
        }
        textView.setPadding(paddingLeft, textView.getPaddingTop(), textView.getPaddingRight(), textView.getPaddingBottom());
        helper.setText(R.id.tv_food_name, item.getProductName());
        helper.setText(R.id.tv_food_number, String.valueOf(item.getNumber()));
    }
}
