package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.contract.NewlyAddedContract;
import com.gingersoft.gsa.cloud.main.mvp.model.service.FoodMenuService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/03/2020 09:53
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class NewlyAddedModel extends BaseModel implements NewlyAddedContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public NewlyAddedModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Observable<BaseResult> addPeriod(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(FoodMenuService.class).addPeriod(requestBody);
    }

    @Override
    public Observable<BaseResult> updatePeriod(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(FoodMenuService.class).updatePeriod(requestBody);
    }

    @Override
    public Observable<BaseResult> deletePeriod(int id) {
        return mRepositoryManager.obtainRetrofitService(FoodMenuService.class).deletePeriod(id);
    }

    @Override
    public Observable<BaseResult> addSummary(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(FoodMenuService.class).addSummary(requestBody);
    }

    @Override
    public Observable<BaseResult> updateSummary(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(FoodMenuService.class).updateSummary(requestBody);
    }
}