package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 18:01
 * Use:
 */
public class SupplierAdapter extends BaseQuickAdapter<SupplierInfoBean, BaseViewHolder> {

    public SupplierAdapter(@Nullable List<SupplierInfoBean> data) {
        super(R.layout.item_supplier, data);
        addChildClickViewIds(R.id.iv_supplier_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, SupplierInfoBean supplierBean) {
        viewHolder.setText(R.id.tv_supplier_name, supplierBean.getSupplierName());
        viewHolder.setText(R.id.tv_supplier_address, supplierBean.getAddress());
        viewHolder.setText(R.id.tv_supplier_phone, supplierBean.getContactInformation());
        viewHolder.setText(R.id.tv_supplier_contact, supplierBean.getContacts());
        viewHolder.setText(R.id.tv_supplier_create_date, TimeUtils.getTime(supplierBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT) + "");
    }
}
