package com.gingersoft.gsa.cloud.base.table.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.qmuiteam.qmui.widget.section.QMUISection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-20
 * 修订历史：2020-05-20
 * 描述：餐檯管理 區域類
 */
@Data
public class TableArea implements Parcelable, QMUISection.Model<TableArea> {

    private Integer id;
    //餐桌id
    private Integer restaurantTableId;
    //區域名稱
    private String regionName;
    //排序
    private Integer sort;
    //是否删除：0正常，1删除
    private Integer deletes;
    //創建人
    private Long uid;
    //更新时间
    private Long updateTime;
    //创建时间
    private Long createTime;

    private List<TableManagerItem> tableItemList = new ArrayList<>();

    /**是否選中*/
    private boolean isChecked = false;

    public TableArea() {
    }

    public TableArea(TableArea area) {
        this.id = area.id;
        this.restaurantTableId = area.restaurantTableId;
        this.regionName = area.regionName;
        this.sort = area.sort;
        this.deletes = area.deletes;
        this.uid = area.uid;
        this.updateTime = area.updateTime;
        this.createTime = area.createTime;
        this.tableItemList = area.tableItemList;
        this.isChecked = area.isChecked;
    }

    @Override
    public TableArea cloneForDiff() {
        return null;
    }

    @Override
    public boolean isSameItem(TableArea other) {
        return false;
    }

    @Override
    public boolean isSameContent(TableArea other) {
        return false;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.id);
        dest.writeValue(this.restaurantTableId);
        dest.writeString(this.regionName);
        dest.writeValue(this.sort);
        dest.writeValue(this.deletes);
        dest.writeValue(this.uid);
        dest.writeValue(this.updateTime);
        dest.writeValue(this.createTime);
        dest.writeList(this.tableItemList);
        dest.writeByte(this.isChecked ? (byte) 1 : (byte) 0);
    }

    protected TableArea(Parcel in) {
        this.id = (Integer) in.readValue(Integer.class.getClassLoader());
        this.restaurantTableId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.regionName = in.readString();
        this.sort = (Integer) in.readValue(Integer.class.getClassLoader());
        this.deletes = (Integer) in.readValue(Integer.class.getClassLoader());
        this.uid = (Long) in.readValue(Long.class.getClassLoader());
        this.updateTime = (Long) in.readValue(Long.class.getClassLoader());
        this.createTime = (Long) in.readValue(Long.class.getClassLoader());
        this.tableItemList = new ArrayList<TableManagerItem>();
        in.readList(this.tableItemList, TableManagerItem.class.getClassLoader());
        this.isChecked = in.readByte() != 0;
    }

    public static final Creator<TableArea> CREATOR = new Creator<TableArea>() {
        @Override
        public TableArea createFromParcel(Parcel source) {
            return new TableArea(source);
        }

        @Override
        public TableArea[] newArray(int size) {
            return new TableArea[size];
        }
    };
}
