package com.gingersoft.gsa.cloud.account.restaurant;


import com.gingersoft.gsa.cloud.account.user.UserConstans;
import com.gingersoft.gsa.cloud.account.user.info.UserInfo;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:
 */
@Data
public class ResturantInfoManager {

    private static ResturantInfoManager sResturantInfoManager = null;

    /**
     * 品牌信息
     */
    private BrandInfo brandInfo;
    /**
     * 餐廳信息
     */
    private RestaurantInfo restaurantInfo;

    private ResturantInfoManager() {
    }

    public static ResturantInfoManager newInstance() {
        if (sResturantInfoManager == null) {
            synchronized (ResturantInfoManager.class) {
                if (sResturantInfoManager == null) {
                    sResturantInfoManager = new ResturantInfoManager();
                }
            }
        }
        return sResturantInfoManager;
    }

    public void putResturantInfo(RestaurantInfo info) {
        SPUtils.put(UserConstans.gsPosShopId, info.getGsPosShopId());
        SPUtils.put(UserConstans.restaurantId, info.getRestaurantId());
        SPUtils.put(UserConstans.restaurantName, info.getRestaurantName());
    }

    public void putBrandInfo(BrandInfo info) {
        SPUtils.put(UserConstans.brandId, info.getBrandId());
        SPUtils.put(UserConstans.brandName, info.getBrandName());
    }

    public void removeResturantInfo() {
        SPUtils.remove(UserConstans.gsPosShopId);
        SPUtils.remove(UserConstans.restaurantId);
        SPUtils.remove(UserConstans.restaurantName);
    }

    public void removeBrandInfo() {
        SPUtils.remove(UserConstans.gsPosShopId);
        SPUtils.remove(UserConstans.restaurantId);
        SPUtils.remove(UserConstans.restaurantName);
    }

}
