package com.gingersoft.gsa.cloud.logan;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.dianping.logan.Logan;
import com.dianping.logan.OnLoganProtocolStatus;
import com.dianping.logan.SendLogCallback;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.BuildConfig;
import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.config.LoganConfig;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.util.QMUIDeviceHelper;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:
 */
public class LoganManager {

    private static final String TAG = LoganManager.class.getSimpleName();


    public static void w_code(String TAG, String log) {
        Logan.w(log, LoganConfig.CODE_LEVLE);
        printLog(TAG, log);
    }

    public static void w_action(String TAG, String log) {
        Logan.w(log, LoganConfig.ACTION_LEVLE);
        printLog(TAG, log);
    }

    public static void w_network(String log) {
        Logan.w(log, LoganConfig.NETWORK_LEVLE);
        //網絡日誌比較重要立即寫入本地
//        Logan.f();
//        printLog("Network", log);
    }

    public static void w_crash(String log) {
        Logan.w(log, LoganConfig.CRASH_LEVLE);
        //cash日誌比較重要立即寫入本地
        Logan.f();
        printLog("AppCrashHandler", log);
    }

    public static void w_H5(String log) {
        Logan.w(log, LoganConfig.H5_LEVLE);
    }

    public static void w_native(String log) {
        Logan.w(log, LoganConfig.native_LEVLE);
    }

    private static void printLog(String TAG, String log) {
        if (BuildConfig.DEBUG) {
            LogUtil.d(TAG, log);
        }
    }

    /**
     * 上傳日誌到服務器
     */
    public static void uploadLog(Context context, boolean showToast) {
        String memberId = GsaCloudApplication.getMemberName() + "_" + GsaCloudApplication.getMemberId();
        String deviceId = DeviceUtils.getDeviceId(GsaCloudApplication.getAppContext());
        String AppVersion = DeviceUtils.getVersionName(GsaCloudApplication.getAppContext()) + "_" + DeviceUtils.getVersionCode(GsaCloudApplication.getAppContext());
        String BuildVersion = android.os.Build.VERSION.RELEASE + "";
        Logan.s(LoganConfig.UPLOAD_LOG_URL, TimeUtils.getCurrentDate(TimeUtils.DATE_FORMAT_DATE), LoganConfig.APP_ID, memberId, deviceId,
                BuildVersion, AppVersion, new SendLogCallback() {
                    @Override
                    public void onLogSendCompleted(int statusCode, byte[] data) {
                        final String resultData = data != null ? new String(data) : "";
                        new Handler(Looper.getMainLooper()).post(new Runnable() {
                            @Override
                            public void run() {
                                if (BuildConfig.DEBUG && showToast) {
                                    if (statusCode == 200) {
                                        ArmsUtils.makeText(context, "日誌上傳成功");
                                    } else {
                                        ArmsUtils.makeText(context, "日誌上傳失敗");
                                    }
                                }
                            }
                        });
                        Log.d(TAG, "upload result, httpCode: " + statusCode + ", details: " + resultData);
                    }
                });
    }
}
