package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;

import com.gingersoft.gsa.cloud.base.utils.PrintTransitUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * view
 */
public class PrintCleanMachine extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getServeBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    /**
     * 獲取"清機報表"圖片
     *
     * @param mContext
     * @return
     */
    private Bitmap getServeBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        View view = PrintTransitUtils.getInstance().getPrintView();
        if (view != null) {
            return viewToZoomBitmap(mContext, view, deviceBean);
        }
        return null;
    }
}
